% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render-json.R
\name{render_json}
\alias{render_json}
\title{Return a json-encoded dictionary with information about javascript-rendered webpage.}
\usage{
render_json(splash_obj = splash_local, url, base_url = NULL,
  quality = 75, width, height, timeout = 30, resource_timeout,
  wait = 0, render_all = FALSE, proxy, js, js_src, filters,
  allowed_domains, allowed_content_types, forbidden_content_types,
  viewport = "1024x768", images, headers, body, http_method, save_args,
  load_args, html = TRUE, png = FALSE, jpeg = FALSE,
  iframes = TRUE, script = TRUE, console = TRUE, history = TRUE,
  har = TRUE, response_body = FALSE)
}
\arguments{
\item{splash_obj}{Object created by a call to \code{\link[=splash]{splash()}}}

\item{url}{The URL to render (required)}

\item{base_url}{The base url to render the page with.}

\item{quality}{JPEG quality parameter in range from 0 to 100. Default is quality=75.}

\item{width}{Resize the rendered image to the given width/height (in
pixels) keeping the aspect ratio. These are optional}

\item{height}{Resize the rendered image to the given width/height (in
pixels) keeping the aspect ratio. These are optional}

\item{timeout}{A timeout (in seconds) for the render (defaults to 30). Without
reconfiguring the startup parameters of the Splash server (not this package)
the maximum allowed value for the timeout is 60 seconds.}

\item{resource_timeout}{A timeout (in seconds) for individual network requests.}

\item{wait}{Time (in seconds) to wait for updates after page is loaded (defaults to 0).}

\item{render_all}{If \code{TRUE} extend the viewport to include the whole webpage
(possibly very tall) before rendering.}

\item{proxy}{Proxy profile name or proxy URL.}

\item{js}{Javascript profile name.}

\item{js_src}{JavaScript code to be executed in page context.}

\item{filters}{Comma-separated list of request filter names.}

\item{allowed_domains}{Comma-separated list of allowed domain names. If present, Splash
won’t load anything neither from domains not in this list nor from subdomains of
domains not in this list.}

\item{allowed_content_types}{Comma-separated list of allowed content types. If present,
Splash will abort any request if the response’s content type doesn’t match any of
the content types in this list. Wildcards are supported.}

\item{forbidden_content_types}{Comma-separated list of forbidden content types. If
present, Splash will abort any request if the response’s content type matches
any of the content types in this list. Wildcards are supported.}

\item{viewport}{View width and height (in pixels) of the browser viewport to render the
web page. Format is “<width>x<height>”, e.g. 800x600. Default value is "full".}

\item{images}{Whether to download images.}

\item{headers}{HTTP headers to set for the first outgoing request.}

\item{body}{Body of HTTP POST request to be sent if method is POST.}

\item{http_method}{HTTP method of outgoing Splash request.}

\item{save_args}{A list of argument names to put in cache.}

\item{load_args}{Parameter values to load from cache}

\item{html}{Whether to include HTML in output.}

\item{png}{Whether to include PNG in output.}

\item{jpeg}{Whether to include JPEG in output.}

\item{iframes}{Whether to include information about child frames in output.}

\item{script}{Whether to include the result of the custom executed javascript final
statement in output}

\item{console}{Whether to include the executed javascript console messages in output.}

\item{history}{Whether to include the history of requests/responses for webpage main frame.
Use it to get HTTP status codes and headers. Only information about "main"
requests/responses is returned (i.e. information about related resources
like images and AJAX queries is not returned). To get information about all
requests and responses use \code{har} parameter.}

\item{har}{Whether to include HAR in output. If \code{TRUE} the result will contain the same
data as \code{\link[=render_har]{render_har()}} provides under \code{har} list entry. By default, response
content is not included. To enable it use \code{response_body} parameter.}

\item{response_body}{Used with \code{har} parameter.}
}
\value{
a huge \code{list}
}
\description{
It can include HTML, PNG and other information, based on arguments passed.
}
\note{
All "whether to include..." parameters are default \code{TRUE} except for \code{png} and
\code{jpeg} and a custom \code{print} method is defined to stop your console from being
overwhelmed with data. Use \code{\link[=str]{str()}} to inspect various portions of the result.
}
\references{
\href{http://splash.readthedocs.io/en/stable/index.html}{Splash docs}
}
\seealso{
Other splash_renderers: \code{\link{execute_lua}},
  \code{\link{render_har}}, \code{\link{render_html}},
  \code{\link{render_jpeg}}, \code{\link{render_png}}
}
\concept{splash_renderers}
