% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmsfp_sap.r
\name{nmsfp_sap}
\alias{nmsfp_sap}
\title{Self-adaptive projection-type method algorithm for nonlinear multiple-sets split feasibility problem}
\usage{
nmsfp_sap(x0, v, w, plist1, plist2, proj, f, df, h, hgrad, delta = 0.3,
  mu = 0.7, beta0 = 1, tol = 1e-10, max_iter = 1000)
}
\arguments{
\item{x0}{Initial iterate}

\item{v}{weights for first set of constraints}

\item{w}{weights for second set of constraints}

\item{plist1}{list of projection functions for first set of constraints; each takes a single point and returns its projection}

\item{plist2}{list of projection functions for second set of constraints; each takes a single point and returns its projection}

\item{proj}{handle to projection operation.}

\item{f}{objective function}

\item{df}{gradient of objective function}

\item{h}{Function handle for output mapping}

\item{hgrad}{Handle for output mapping Jacobian}

\item{delta}{step-size parameter}

\item{mu}{step-size parameter}

\item{beta0}{initial}

\item{tol}{Tolerance}

\item{max_iter}{Maximum number of iterations}
}
\description{
\code{nmsfp_sap} performs the self-adaptive projection-type method of Li et al.
}
