% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concat.split.R
\name{concat.split.multiple}
\alias{concat.split.multiple}
\title{Split Concatenated Cells and Optionally Reshape the Output}
\usage{
concat.split.multiple(data, split.cols, seps = ",", direction = "wide", ...)
}
\arguments{
\item{data}{The source \code{data.frame} or \code{data.table}.}

\item{split.cols}{A vector of columns that need to be split.}

\item{seps}{A vector of the separator character used in each column. If all
columns use the same character, you can enter that single character.}

\item{direction}{The desired form of the resulting \code{data.frame} or
\code{data.table}, either \code{'wide'} or \code{'long'}.  Defaults to
\code{'wide'}.}

\item{\dots}{Other arguments to \code{\link{cSplit}}.}
}
\value{
A \code{data.table}.
}
\description{
This is a wrapper for the \code{\link{cSplit}} function to maintain
backwards compatibility with earlier versions of the "splitstackshape"
package. It allows the user to split multiple columns at once and optionally
convert the results into a "long" format.
}
\examples{

temp <- head(concat.test)
concat.split.multiple(temp, split.cols = c("Likes", "Hates", "Siblings"),
                      seps = c(",", ";", ","))
concat.split.multiple(temp, split.cols = c("Likes", "Siblings"),
                      seps = ",", direction = "long")
\dontshow{rm(temp)}

}
\seealso{
\code{\link{cSplit}}, for which this is simply a wrapper, and
\code{\link{concat.split}}, \code{\link{concat.split.compact}},
\code{\link{concat.split.expanded}}, \code{\link{concat.split.multiple}},
\code{\link{Reshape}}
}
\author{
Ananda Mahto
}
