% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm12_fmri_spec.R
\name{build_spm12_first_level_spec}
\alias{build_spm12_first_level_spec}
\alias{spm12_first_level_spec}
\title{SPM12 fMRI First Level Specification}
\usage{
build_spm12_first_level_spec(scans = NULL, outdir = NULL,
  units = c("scans", "secs"), slice_timed = TRUE, nslices = NULL,
  ref_slice = NULL, tr, condition_mat = NULL, condition_list = NULL,
  regressor_mat = NULL, regressor_list = NULL, hpf = 128,
  time_deriv = FALSE, disp_deriv = FALSE, interactions = FALSE,
  global_norm = c("None", "Scaling"), mthresh = 0.8, mask = NULL,
  correlation = c("AR(1)", "none", "FAST"), n_time_points = NULL,
  verbose = TRUE, overwrite = TRUE, ...)

spm12_first_level_spec(..., outdir = NULL, add_spm_dir = TRUE,
  spmdir = spm_dir(verbose = verbose), clean = TRUE, verbose = TRUE,
  overwrite = TRUE)
}
\arguments{
\item{scans}{images to run}

\item{outdir}{output directory for results}

\item{units}{The onsets of events or blocks can be 
specified in either scans or seconds.}

\item{slice_timed}{Were the image slice-time corrected}

\item{nslices}{If the data were slice-time corrected, the number of 
slices of the image}

\item{ref_slice}{If the data were slice-time corrected, the 
reference slice}

\item{tr}{The repetition time, in seconds}

\item{condition_mat}{multiple condition mat/txt file}

\item{condition_list}{List of conditions:
see \code{\link{spm12_condition}}.  This should be a list 
(or a list of lists) which have the items:
\code{name}, \code{onset}, \code{duration}, \code{time_mod_order},
\code{param_mod}, \code{orth}.  \code{name} does not need to be specified
if it is a named list of lists.}

\item{regressor_mat}{multiple regressor mat/txt file}

\item{regressor_list}{List of regressors:
see \code{\link{spm12_regressor}}.  This should be a list 
(or a list of lists) which have the items:
\code{name}, \code{value}, and \code{n_time_points}. 
\code{name} does not need to be specified
if it is a named list of lists.}

\item{hpf}{High pass filter, in seconds.}

\item{time_deriv}{time derivative. 
The time derivative allows the peak response to  vary  by  plus  
or  minus  a  second.}

\item{disp_deriv}{dispersion derivative, allows the width of 
the response to vary.}

\item{interactions}{Model interactions, 
Generalized convolution of inputs with basis set.}

\item{global_norm}{Global intensity normalisation}

\item{mthresh}{Masking threshold, defined as proportion of globals.}

\item{mask}{Specify an image for explicitly masking the analysis.}

\item{correlation}{Serial correlations in fMRI time series}

\item{n_time_points}{Number of time points}

\item{verbose}{Print diagnostic messages}

\item{overwrite}{If a SPM.mat file exists in the outdir, 
should the file be removed?}

\item{...}{Arguments passed to \code{\link{run_spm12_script}}}

\item{add_spm_dir}{Add SPM12 directory from this package}

\item{spmdir}{SPM dir to add, will use package default directory}

\item{clean}{Remove scripts from temporary directory after running}
}
\value{
A list of objects, including an spm object and output files.
}
\description{
SPM12 fMRI First Level Specification
}
