% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm12_regressor.R
\name{spm12_regressor}
\alias{spm12_regressor}
\alias{spm12_regressor_list}
\title{Build Regressors for SPM12 first level model}
\usage{
spm12_regressor(name, value, n_time_points)

spm12_regressor_list(reg, n_time_points)
}
\arguments{
\item{name}{Name of the regressor}

\item{value}{Value of the regressor, must be the same length as
\code{n_time_points}}

\item{n_time_points}{Number of time points for the analysis}

\item{reg}{List of regressors}
}
\value{
A list of objects, each with a \code{name} and \code{value}
}
\description{
Build Regressors for SPM12 first level model
}
\examples{
res = spm12_regressor(name = "condition1", value = c(
rep(1, 10), rep(0, 10)), n_time_points = 20)
print(res)
L = list(
cond1 = list(value = c(rep(1, 10), rep(0, 10)), n_time_points = 20),
cond2 = list(value = c(rep(0, 10), rep(1, 10)), n_time_points = 20)
)
res = spm12_regressor_list(L, n_time_points = 20)
print(res)
}
