% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.matrix.R, R/model.matrix_glm.R
\name{model.matrix.spmodel}
\alias{model.matrix.spmodel}
\alias{model.matrix.splm}
\alias{model.matrix.spautor}
\alias{model.matrix.spglm}
\alias{model.matrix.spgautor}
\title{Extract the model matrix from a fitted model object}
\usage{
\method{model.matrix}{splm}(object, ...)

\method{model.matrix}{spautor}(object, ...)

\method{model.matrix}{spglm}(object, ...)

\method{model.matrix}{spgautor}(object, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
The model matrix (of the fixed effects), whose rows represent
observations and whose columns represent explanatory variables corresponding
to each fixed effect.
}
\description{
Extract the model matrix (X) from a fitted model object.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
model.matrix(spmod)
}
\seealso{
\code{\link[stats:model.matrix]{stats::model.matrix()}}
}
