\name{occ_options}
\alias{occ_options}
\title{Look up options for parameters passed to each source}
\usage{
occ_options(from = "gbif")
}
\arguments{
  \item{from}{(character) Data source to get data from, any
  combination of gbif, bison, inat, ebird, AntWeb, and/or
  ecoengine}
}
\value{
Opens up the documentation for the function that is used
internally within the occ function for each source.
}
\description{
Look up options for parameters passed to each source
}
\details{
Any of the parameters passed to e.g. occ_search() from the
rgbif package can be passed in the associated gbifopts list
in occ().

Note that the from parameter is lowercased within the
function and is called through match.arg first, so you can
match on unique partial strings too (e.g., 'e' for
'ecoengine').
}
\examples{
occ_options()
occ_options('ecoengine')
occ_options('AntWeb')
}

