% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbt_run.R
\name{bbt_run}
\alias{bbt_run}
\title{BBT rating algorithm}
\usage{
bbt_run(formula, data, r, rd, sigma, weight, beta = 25/6, kappa = 0.5,
  gamma, idlab, init_r = 25, init_rd = 25/3, pb = FALSE)
}
\arguments{
\item{formula}{formula specifying model. BBT algorithm allows only player ranking parameter and should be specified by following manner: 
`rank | id ~ name`. Names in formula are unrestricted, but model structure remains the same:
\itemize{
 \item rank player position in event.
 \item id event identifier in which pairwise comparison is assessed.
 \item name of player.
}}

\item{data}{data.frame which contains columns specified in formula, and optionaly columns defined by `sigma`, `weight` or `date`.}

\item{r}{named vector of initial rating estimates. In there is no assumption, initial ratings is set to be r=25 Names of vector should correspond with `name` in formula.}

\item{rd}{named vector of initial rating deviation estimates. In there is no assumption, initial is set to be r=25/3 Names of vector should correspond with `name` in formula.}

\item{sigma}{name of column in `data` containing rating volatility. Rating volitality is a value which multiplies prior `rd`. If `sigma > 0` then prior `rd` increases, making estimate of `r` more uncertain.}

\item{weight}{name of column in `data` containing weights. Weights increasing or decreasing update change. Higher weight increasing impact of corresponding event.}

\item{beta}{The additional variance of performance. As beta increases, the performance is more uncertain and update change is smaller. By default `beta = 25/6`.}

\item{kappa}{controls `rd` shrinkage not to be greater than `rd*(1-kappa)`. `kappa=1` means that `rd` will not be decreased.}

\item{gamma}{can help to control how fast the variance `rd` is reduced after updating. Lower `gamma` slows decreasing of `rd`, which tends to reach zero to quickly. The default value is `gamma = rd/c`.}

\item{idlab}{name of column in `data` containing date. Doesn't affect estimation process. If specified, charts displays estimates changes in time instead of by observation `id`}

\item{init_r}{initial values for `r` if not provided. Default = 25}

\item{init_rd}{initial values for `r` if not provided. Default = 25/3}

\item{pb}{logical, if TRUE progress bar will appear in console. Default = FALSE}
}
\value{
A "ratings" object is returned
\itemize{
  \item \code{final_r} named vector containing players ratings.
  \item \code{final_rd} named vector containing players ratings deviations.
  \item \code{r} data.frame with evolution of the ratings and ratings deviations estimated at each event.
  \item \code{pairs} pairwise combinations of players in analysed events with prior probability and result of a challange.
  \item \code{class} of the object
  \item \code{method} type of algorithm used
  \item \code{formula} modelled formula
}
}
\description{
BBT rating algorithm
Wrapper arround `bbt` update algorithm. Wrapper allows user to simplify calculation providing only data and initial parameters assumptions
}
\examples{
# Example from Glickman
data <- data.frame( name = c( "A", "B", "C", "D" ), 
                    rank = c( 3, 4, 1, 2 ))
bbt <- bbt_run( rank ~ name, data )
}
