% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glicko2_run.R
\name{glicko2_run}
\alias{glicko2_run}
\title{Glicko2 rating algorithm}
\usage{
glicko2_run(formula, data, r, rd, sigma, tau = 0.5, weight,
  kappa = 0.5, idlab, init_r = 1500, init_rd = 350, pb = FALSE)
}
\arguments{
\item{formula}{formula specifying model. Glicko2 algorithm allows only player ranking parameter and should be specified by following manner: 
`rank | id ~ name`. Names in formula are unrestricted, but model structure remains the same:
\itemize{
 \item rank player position in event.
 \item id event identifier in which pairwise comparison is assessed.
 \item name of player.
}}

\item{data}{data.frame which contains columns specified in formula, and optionaly columns defined by `weight` or `date`.}

\item{r}{named vector of initial rating estimates. In there is no assumption, initial ratings is set to be r=1500. Names of vector should correspond with team_name label.}

\item{rd}{named vector of initial rating deviation estimates. In there is no assumption, initial ratings is set to be r=300 Names of vector should correspond with team_name label.}

\item{sigma}{named vector of rating volatile. In there is no assumption, initial ratings should be sigma=0.5. Names of vector should correspond with team_name label.}

\item{tau}{The system constant. Which constrains the change in volatility over time. Reasonable choices are between 0.3 and 1.2 (`default = 0.5`), though the system should be tested to decide which value results in greatest predictive accuracy. Smaller values of `tau` prevent the volatility measures from changing by largeamounts, which in turn prevent enormous changes in ratings based on very improbable results. If the application of Glicko-2 is expected to involve extremely improbable collections of game outcomes, then `tau` should be set to a small value, even as small as, say, `tau= 0`.2.}

\item{weight}{name of column in `data` containing weights. Weights increasing or decreasing update change. Higher weight increasing impact of corresponding event.}

\item{kappa}{controls `rd` shrinkage not to be greater than `rd*(1-kappa)`. `kappa=1` means that `rd` will not be decreased.}

\item{idlab}{name of column in `data` containing date. Doesn't affect estimation process. If specified, charts displays estimates changes in time instead of by event `id`}

\item{init_r}{initial values for `r` if not provided. Default = 1500}

\item{init_rd}{initial values for `r` if not provided. Default = 350}

\item{pb}{logical, if TRUE progress bar will appear in console. Default = FALSE}
}
\value{
A "rating" object is returned
\itemize{
  \item \code{final_r} named vector containing players ratings.
  \item \code{final_rd} named vector containing players ratings deviations.
  \item \code{final_sigma} named vector containing players ratings volatiles.
  \item \code{r} data.frame with evolution of the ratings and ratings deviations estimated at each event.
  \item \code{pairs} pairwise combinations of players in analysed events with prior probability and result of a challange.
  \item \code{class} of the object
  \item \code{method} type of algorithm used
  \item \code{formula} modelled formula
}
}
\description{
Glicko2 rating algorithm
Wrapper arround `glicko2` update algorithm. Wrapper allows user to simplify calculation providing only data and initial parameters assumptions
}
\examples{
# Example from Glickman
data <- data.frame( name = c( "A", "B", "C", "D" ), 
                    rank = c( 3, 4, 1, 2 ))
glicko2 <- glicko2_run( rank ~ name, data )
}
