% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse.R
\name{get_new_releases}
\alias{get_new_releases}
\title{Get new releases}
\usage{
get_new_releases(
  country = NULL,
  limit = 20,
  offset = 0,
  authorization = get_spotify_access_token(),
  include_meta_info = FALSE
)
}
\arguments{
\item{country}{Optional. A country: an
\href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 3166-1 alpha-2 country code}.
Provide this parameter if you want the list of returned items to be relevant to a
particular country. If omitted, the returned items will be relevant to all countries.}

\item{limit}{Optional. The maximum number of items to return. Default: 20. Minimum: 1. Maximum: 50.}

\item{offset}{Optional. The index of the first item to return. Default: 0 (the first object). Use with \code{limit} to get the next set of items.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}}

\item{include_meta_info}{Optional. Boolean indicating whether to include full result, with meta information such as \code{"country"}, \code{"offset"}, and \code{"limit"}. Defaults to \code{FALSE}.}
}
\value{
Returns a data frame of results containing new releases. \cr
See \url{https://developer.spotify.com/documentation/web-api/reference/#category-browse} for more information.
}
\description{
Get a list of new album releases featured in Spotify (shown, for example,
on a Spotify player’s “Browse” tab).
}
\examples{
\dontrun{
## Get new Swedish music
get_new_releases(country = 'SE', limit = 5)
}
}
