% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_coverage.R
\name{expected_coverage}
\alias{expected_coverage}
\title{Expected coverage}
\usage{
expected_coverage(x, n, strata, alpha = 0.001, cutoff = Inf)
}
\arguments{
\item{x}{A positive and finite numeric vector of sizes for units in the
population (e.g., revenue for drawing a sample of businesses).}

\item{n}{A positive integer giving the sample size.}

\item{strata}{A factor, or something that can be coerced into one, giving
the strata associated with units in the population. The default is to place
all units into a single stratum.}

\item{alpha}{A numeric vector with values between 0 and 1 for each stratum,
ordered according to the levels of \code{strata}. Units with inclusion
probabilities greater than or equal to 1 - \code{alpha} are set to 1 for
each stratum. A single value is recycled for all strata. The default is
slightly larger than 0.}

\item{cutoff}{A positive numeric vector of cutoffs for each stratum, ordered
according to the levels of \code{strata}. Units with \code{x >= cutoff} get
an inclusion probability of 1 for each stratum. A single value is recycled
for all strata. The default does not apply a cutoff.}
}
\value{
The expected number of strata covered by the sample design.
}
\description{
Find the expected number of strata covered by ordinary Poisson sampling
without stratification. As sequential and ordinary Poisson sampling have the
same sample size on average, this gives an approximation for the coverage
under sequential Poisson sampling.

This function can also be used to calculate, e.g., the expected number of
enterprises covered within a stratum when sampling business establishments.
}
\examples{
# Make a population with units of different size
x <- c(rep(1:9, each = 3), 100, 100, 100)

# ... and 10 strata
s <- rep(letters[1:10], each = 3)

# Should get about 7 to 8 strata in a sample on average
expected_coverage(x, 15, s)

}
\seealso{
\code{\link[=prop_allocation]{prop_allocation()}} for generating proportional-to-size allocations.
}
