% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimACDC.R
\name{optimACDC}
\alias{ACDC}
\alias{objACDC}
\alias{optimACDC}
\title{Optimization of sample configurations for spatial trend identification and estimation (III)}
\usage{
optimACDC(points, candi, covars, strata.type = "area", use.coords = FALSE,
  schedule = scheduleSPSANN(), plotit = FALSE, track = FALSE, boundary,
  progress = "txt", verbose = FALSE, weights = list(CORR = 0.5, DIST =
  0.5), nadir = list(sim = NULL, seeds = NULL, user = NULL, abs = NULL),
  utopia = list(user = NULL, abs = NULL))

objACDC(points, candi, covars, strata.type = "area", use.coords = FALSE,
  weights = list(CORR = 0.5, DIST = 0.5), nadir = list(sim = NULL, seeds =
  NULL, user = NULL, abs = NULL), utopia = list(user = NULL, abs = NULL))
}
\arguments{
\item{points}{Integer value, integer vector, data frame or matrix. If \code{points} is an integer value, 
it defines the number of points that should be randomly sampled from \code{candi} to form the starting 
system configuration. If \code{points} is a vector of integer values, it contains the row indexes of 
\code{candi} that correspond to the points that form the starting system configuration. If \code{points} 
is a data frame or matrix, it must have three columns in the following order: \code{[, "id"]} the row 
indexes of \code{candi} that correspond to each point, \code{[, "x"]} the projected x-coordinates, and 
\code{[, "y"]} the projected y-coordinates. Note that in the later case, \code{points} must be a subset 
of \code{candi}.}

\item{candi}{Data frame or matrix with the candidate locations for the jittered points. \code{candi} must 
have two columns in the following order: \code{[, "x"]} the projected x-coordinates, and \code{[, "y"]} the 
projected y-coordinates.}

\item{covars}{Data frame or matrix with the covariates in the columns.}

\item{strata.type}{Character value setting the type of stratification that should be used to create the 
marginal sampling strata (or factor levels) for the numeric covariates. Available options are \code{"area"},
for equal-area, and \code{"range"}, for equal-range. Defaults to \code{strata.type = "area"}.}

\item{use.coords}{Logical value. Should the geographic coordinates be used as covariates? Defaults to 
\code{use.coords = FALSE}.}

\item{schedule}{List with 11 named sub-arguments defining the control parameters of the cooling schedule. 
See \code{\link[spsann]{scheduleSPSANN}}.}

\item{plotit}{Logical for plotting the optimization results, including a) the progress of the objective
function, and b) the starting (gray) and current system configuration (black), and the maximum jitter in 
the x- and y-coordinates. The plots are updated at each 10 jitters. Defaults to \code{plotit = FALSE}.}

\item{track}{Logical value. Should the evolution of the energy state be recorded and returned with the 
result? If \code{track = FALSE} (the default), only the starting and ending energy states are returned with
the results.}

\item{boundary}{SpatialPolygon defining the boundary of the spatial domain. If missing and 
\code{plotit = TRUE}, \code{boundary} is estimated from \code{candi}.}

\item{progress}{Type of progress bar that should be used, with options \code{"txt"}, for a text progress 
bar in the R console, \code{"tk"}, to put up a Tk progress bar widget, and \code{NULL} to omit the progress
bar. A Tk progress bar widget is useful when using parallel processors. Defaults to 
\code{progress = "txt"}.}

\item{verbose}{Logical for printing messages about the progress of the optimization. Defaults to 
\code{verbose = FALSE}.}

\item{weights}{List with named sub-arguments. The weights assigned to each one of the objective functions
that form the multi-objective combinatorial optimization problem. They must be named after the respective 
objective function to which they apply. The weights must be equal to or larger than 0 and sum to 1. The 
default option gives equal weights to all objective functions.}

\item{nadir}{List with named sub-arguments. Three options are available: 1) \code{sim} -- the number of 
simulations that should be used to estimate the nadir point, and \code{seeds} -- vector defining the random
seeds for each simulation; 2) \code{user} -- a list of user-defined nadir values named after the respective
objective functions to which they apply; 3) \code{abs} -- logical for calculating the nadir point 
internally (experimental).}

\item{utopia}{List with named sub-arguments. Two options are available: 1) \code{user} -- a list of 
user-defined values named after the respective objective functions to which they apply; 2) \code{abs} --
logical for calculating the utopia point internally (experimental).}
}
\value{
\code{optimACDC} returns an object of class \code{OptimizedSampleConfiguration}: the optimized sample
configuration with details about the optimization.

\code{objACDC} returns a numeric value: the energy state of the sample configuration -- the objective
function value.
}
\description{
Optimize a sample configuration for spatial trend identification and estimation. An utility function 
\emph{U} is defined so that the sample reproduces the bivariate association/correlation between the 
covariates, as well as their marginal distribution (\bold{ACDC}). The utility function is obtained 
aggregating two objective functions: \bold{CORR} and \bold{DIST}.
}
\details{
The help page of \code{\link[spsann]{minmaxPareto}} contains details on how \pkg{spsann} solves the
multi-objective combinatorial optimization problem of finding a globally optimum sample configuration that
meets multiple conflicting objectives.

Details about the mechanism used to generate a new sample configuration out of the current sample 
configuration by randomly perturbing the coordinates of a sample point are available in the help page of
\code{\link[spsann]{spJitter}}.

Visit the help pages of \code{\link[spsann]{optimCORR}} and \code{\link[spsann]{optimDIST}} to see the 
details of the objective functions that compose \bold{ACDC}.
}
\note{
The distance between two points is computed as the Euclidean distance between them. This computation 
assumes that the optimization is operating in the two-dimensional Euclidean space, i.e. the coordinates of
the sample points and candidate locations should not be provided as latitude/longitude. \pkg{spsann} has no 
mechanism to check if the coordinates are projected: the user is responsible for making sure that this
requirement is attained.

This function was derived with modifications from the method known as the \emph{conditioned Latin Hypercube 
sampling} originally proposed by Minasny and McBratney (2006), and implemented in the R-package 
\pkg{\link[clhs]{clhs}} by Pierre Roudier.
}
\examples{
data(meuse.grid, package = "sp")
candi <- meuse.grid[1:1000, 1:2]
nadir <- list(sim = 10, seeds = 1:10)
utopia <- list(user = list(DIST = 0, CORR = 0))
covars <- meuse.grid[1:1000, 5]
schedule <- scheduleSPSANN(
  chains = 1, initial.temperature = 5, x.max = 1540, y.max = 2060, 
  x.min = 0, y.min = 0, cellsize = 40)
set.seed(2001)
res <- optimACDC(
  points = 10, candi = candi, covars = covars, nadir = nadir,
  use.coords = TRUE, utopia = utopia, schedule = schedule)
objSPSANN(res) - objACDC(
  points = res, candi = candi, covars = covars, 
  use.coords = TRUE, nadir = nadir, utopia = utopia)
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
\references{
Minasny, B.; McBratney, A. B. A conditioned Latin hypercube method for sampling in the presence of 
ancillary information. \emph{Computers & Geosciences}, v. 32, p. 1378-1388, 2006.

Minasny, B.; McBratney, A. B. Conditioned Latin Hypercube Sampling for calibrating soil sensor data to soil
properties. Chapter 9. Viscarra Rossel, R. A.; McBratney, A. B.; Minasny, B. (Eds.) \emph{Proximal Soil
Sensing}. Amsterdam: Springer, p. 111-119, 2010.

Roudier, P.; Beaudette, D.; Hewitt, A. A conditioned Latin hypercube sampling algorithm incorporating
operational constraints. \emph{5th Global Workshop on Digital Soil Mapping}. Sydney, p. 227-231, 2012.
}
\seealso{
\code{\link[clhs]{clhs}}, \code{\link[pedometrics]{cramer}}
}
\concept{
simulated annealing

spatial trend
}
\keyword{iteration}
\keyword{optimize}
\keyword{spatial}

