% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irs.R
\name{irs}
\alias{irs}
\title{Select an Independent Random Sample (IRS)}
\usage{
irs(design, DesignID = "Site", SiteBegin = 1, type.frame = "finite",
  src.frame = "shapefile", in.shape = NULL, sp.object = NULL,
  att.frame = NULL, id = NULL, xcoord = NULL, ycoord = NULL,
  stratum = NULL, mdcaty = NULL, maxtry = 1000, shapefile = TRUE,
  prjfilename = NULL, out.shape = "sample")
}
\arguments{
\item{design}{Named list of stratum design specifications which are also
lists.  Stratum names must be subset of values in stratum argument.  Each
stratum list has four components:
\describe{
  \item{panel}{named vector of sample sizes for each panel in stratum}
  \item{seltype}{the type of random selection, which must be one of
    following: "Equal" - equal probability selection, "Unequal" - unequal
    probability selection by the categories specified in caty.n and mdcaty,
    or "Continuous" - unequal probability selection proportional to
    auxiliary variable mdcaty}
  \item{caty.n}{if seltype equals "Unequal", a named vector of sample sizes
    for each category specified by mdcaty, where sum of the sample sizes
    must equal sum of the panel sample sizes, and names must be a subset of
    values in mdcaty}
  \item{over}{number of replacement sites ("oversample" sites) for the
    entire design, which is set equal to 0 if none are required)}
}
Example design for a stratified sample:\cr
  design=list(
    Stratum1=list(panel=c(PanelOne=50), seltype="Equal", over=10),
    Stratum2=list(panel=c(PanelOne=50, PanelTwo=50), seltype="Unequal",
      caty.n=c(CatyOne=25, CatyTwo=25, CatyThree=25, CatyFour=25),
      over=75))
Example design for an unstratified sample:\cr
  design <- list(
    None=list(panel=c(Panel1=50, Panel2=100, Panel3=50), seltype="Unequal",
      caty.n=c("Caty 1"=50, "Caty 2"=25, "Caty 3"=25, "Caty 4"=25,
      "Caty 5"=75), over=100))}

\item{DesignID}{Name for the design, which is used to create a site ID for
each site.  The default is "Site".}

\item{SiteBegin}{Number to use for first site in the design.  The default
is 1.}

\item{type.frame}{The type of frame, which must be one of following:
"finite", "linear", or "area".  The default is "finite".}

\item{src.frame}{Source of the frame, which equals "shapefile" if the frame
is to be read from a shapefile, "sp.object" if the frame is obtained from
an sp package object, or "att.frame" if type.frame equals "finite" and the
frame is included in att.frame.  The default is "shapefile".}

\item{in.shape}{Name (without any extension) of the input shapefile.  If
src.frame equal "shapefile" and in.shape equals NULL, then the shapefile or
shapefiles in the working directory are used.  The default is NULL.}

\item{sp.object}{Name of the sp package object when src.frame equals
"sp.object". The default is NULL.}

\item{att.frame}{Data frame composed of attributes associated with elements
in the frame, which must contain the columns used for stratum and mdcaty
(if required).  If src.frame equals "shapefile" and att.frame equals NULL,
then att.frame is created from the dbf file(s) in the working directory. If
src.frame equals "att.frame", then att.frame includes columns that contain
x-coordinates and y-coordinates for each element in the frame. The default
is NULL.}

\item{id}{Character string containing the name of the column from att.frame
that identifies the ID value for each element in the frame.  If id equals
NULL, a column named "id" that contains values from one through the number
of rows in att.frame is added to att.frame.  The default is NULL.}

\item{xcoord}{Character string containing the name of the column from
att.frame that identifies x-coordinates when src.frame equals "att.frame".
If xcoord equals NULL, then xcoord is given the value "x".  The default is
NULL.}

\item{ycoord}{Character string containing the name of the column from
att.frame that identifies y-coordinates when src.frame equals "att.frame".
If ycoord equals NULL, then ycoord is given the value "y".  The default is
NULL.}

\item{stratum}{Character string containing the name of the column from
att.frame that identifies stratum membership for each element in the frame.
If stratum equals NULL, the design is unstratified, and a column named
"stratum" (with all of its elements equal to the stratum name specified in
design) is added to att.frame.  The default is NULL.}

\item{mdcaty}{Character string containing the name of the column from
att.frame that identifies the unequal probability category for each element
in the frame.  The default is NULL.}

\item{maxtry}{Maximum number of iterations for randomly generating a point
within the frame to select a site when type.frame equals "area".  The
default is 1000.}

\item{shapefile}{Option to create a shapefile containing the survey design
information,  where TRUE equals create a shapefile and FALSE equals do not
create a shapefile.  The default is TRUE.}

\item{prjfilename}{Name (without any extension) of the project file for an
input shapefile.  The default is NULL.}

\item{out.shape}{Name (without any extension) of the output shapefile
containing the survey design information.  The default is "sample".}
}
\value{
An object of class SpatialDesign containing the survey design
  information and any additional attribute variables that were provided.
  Optionally, a shapefile can be created that contains the survey design
  information.
}
\description{
Select an independent random sample from a point, linear, or areal frame.
Frame elements must be located in 1- or 2-dimensional coordinate system. May
designate panels of sites for surveys over time.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{getRecordShapeSizes}}{C function to read the shp file
      of a line or polygon shapefile and return the length or area for each
      record in the shapefile}
    \item{\code{\link{irsarea}}}{select an IRS sample of an area resource}
    \item{\code{\link{irslin}}}{select an IRS sample of a linear resource}
    \item{\code{\link{irspts}}}{select an IRS sample of a finite resource}
    \item{\code{\link{read.dbf}}}{function to read the dbf file of a
      shapefile and return a data frame containing contents of the file}
    \item{\code{readShapeFilePts}}{C function to read the shp file of
      a point shapefile and return a data frame containing the x-coordinates
      and y-coordinates for elements in the frame}
    \item{\code{\link{SpatialPoints}}}{sp package function to create an
      object of class SpatialPoints}
    \item{\code{\link{SpatialPointsDataFrame}}}{sp package function to create
      an object of class SpatialPointsDataFrame}
    \item{\code{writeShapeFilePoint}}{C function to create a shapefile
      containing the survey design information}
  }
}

\examples{
\dontrun{
  test.design <- list(
    Stratum1=list(panel=c(PanelOne=50), seltype="Equal", over=10),
    Stratum2=list(panel=c(PanelOne=50, PanelTwo=50), seltype="Unequal",
      caty.n=c(CatyOne=25, CatyTwo=25, CatyThree=25, CatyFour=25), over=75))
  test.attframe <- read.dbf("test.shapefile")
  test.sample <- grts(design=test.design, DesignID="Test.Site",
    type.frame="area", src.frame="shapefile", in.shape="test.shapefile",
    att.frame=test.attframe, stratum="test.stratum", mdcaty="test.mdcaty",
    shapefile=TRUE, out.shape="test.sample")
}

}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
\keyword{survey}
