% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ash1.wgt.R
\name{ash1.wgt}
\alias{ash1.wgt}
\title{Compute the Average Shifted Histogram (ASH) for Weighted Data}
\usage{
ash1.wgt(x, wgt = rep(1, length(x)), m = 5, nbin = 50, ab = NULL,
  support = "Continuous")
}
\arguments{
\item{x}{Vector of data used to estimate the density. NAs are allowed}

\item{wgt}{Vector of Weights for each observation from a probability sample.
The default is equal weights (equal probability).}

\item{m}{The number of empty bins to add to the ends when the range is not
completely specified.  The default is 5.}

\item{nbin}{The number of bins for density estimation.  The default is 50.}

\item{ab}{Optional range for support associated with the density. Both
values may be equal to NA.  If equal to NA, then corresponding limit will
be based on nicerange(). The default is NULL.}

\item{support}{The type of support.  If equal to "Continuous", then data are
from a continuous distribution.  If equal to "Ordinal", then data are from
a discrete distribution defined for integers only.  The default is
"Continuous".}
}
\value{
A list containing the ASH density estimate.  List consists of
  \itemize{
    \item tcen - x-coordinate for center of bin
    \item f - y-coordinate for density estimate height
  }
}
\description{
Calculate the average shifted histogram estimate of a density based on data
  from a survey design with weights.
}
\examples{
x <- rnorm(100, 10, sqrt(10))
wgt <- runif(100, 10, 100)
rslt <- ash1.wgt(x, wgt)
plot(rslt)

}
\references{
Scott, D. W. (1985). "Averaged shifted histograms: effective nonparametric 
  density estimators in several dimensions." The Annals of Statistics 13(3):
  1024-1040.
}
\author{
Tony Olsen \email{Olsen.tony@epa.gov}
}
\keyword{misc}
\keyword{survey}
