% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simex.R
\name{simex}
\alias{simex}
\title{Internal Function: Extrapolation for Simulation-Extrapolation Function}
\usage{
simex(z, val, sigma, var.sigma, cluster.ind, cluster)
}
\arguments{
\item{z}{Vector of the response value for each site.}

\item{val}{Vector of the set of values at which the CDF is estimated.}

\item{sigma}{Measurement error variance.}

\item{var.sigma}{Variance of the estimated measurement error variance.}

\item{cluster.ind}{Logical value that indicates whether the survey design
utilizes two stages.}

\item{cluster}{Vector of the stage one sampling unit (primary sampling unit
or cluster) code for each site.}
}
\value{
Output is a list containing the following matrices:
  \describe{
    \item{g}{values of the function g(.) evaluated at val for each value of z}
    \item{dg}{values of the derivative of the function g(.)}
  }
}
\description{
This function executes the extrapolation step of the simulation extrapolation
deconvolution method (Stefanski and Bay, 1996).  The function can accomodate
single-stage and two-stage samples.
}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
