% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_survey.r
\name{as_survey}
\alias{as_survey}
\alias{as_survey.data.frame}
\alias{as_survey.survey.design2}
\alias{as_survey.svyrepdesign}
\alias{as_survey.tbl_sql}
\alias{as_survey.twophase2}
\alias{as_survey_}
\title{Create a tbl_svy from a data.frame}
\usage{
as_survey(.data, ...)

\method{as_survey}{data.frame}(.data, ...)

\method{as_survey}{tbl_sql}(.data, ...)

\method{as_survey}{survey.design2}(.data, ...)

\method{as_survey}{svyrepdesign}(.data, ...)

\method{as_survey}{twophase2}(.data, ...)

as_survey_(.data, ...)
}
\arguments{
\item{.data}{a data.frame or an object from the survey package}

\item{...}{other arguments, see other functions for details}
}
\value{
a tbl_svy
}
\description{
\code{as_survey} can be used to create a \code{tbl_svy} using design information
(\code{\link{as_survey_design}}), replicate weights (\code{\link{as_survey_rep}}),
or a two phase design (\code{\link{as_survey_twophase}}), or an object created by the
survey package. \code{as_survey_} is its standard evaluation counterpart.
}
\details{
There is also limited support for databases using dplyr's \code{tbl_sql}
objects for survey designs and replicate weight surveys.
Not all operations are available for these objects, in particular
two phase designs do not work.
See \code{vignette("databases", package = "dplyr")}
for more information on setting up databases in dplyr.
}
\examples{
# Examples from ?survey::svydesign
library(survey)
library(dplyr)
data(api)

# stratified sample
dstrata <- apistrat \%>\%
  as_survey(strata = stype, weights = pw)

# Examples from ?survey::svrepdesign
data(scd)
# use BRR replicate weights from Levy and Lemeshow
scd$rep1 <- 2 * c(1, 0, 1, 0, 1, 0)
scd$rep2 <- 2 * c(1, 0, 0, 1, 0, 1)
scd$rep3 <- 2 * c(0, 1, 1, 0, 0, 1)
scd$rep4 <- 2 * c(0, 1, 0, 1, 1, 0)

scdrep <- scd \%>\%
  as_survey(type = "BRR", repweights = starts_with("rep"),
                    combined_weights = FALSE)

# Examples from ?survey::twophase
# two-phase simple random sampling.
data(pbc, package="survival")

pbc <- pbc \%>\%
  mutate(randomized = !is.na(trt) & trt > 0,
         id = row_number())
d2pbc <- pbc \%>\%
  as_survey(id = list(id, id), subset = randomized)

# as_survey_ uses standard evaluation
dstrata <- apistrat \%>\%
  as_survey_(strata = "stype", weights = "pw")

}

