% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_statistics.r
\name{unweighted}
\alias{unweighted}
\title{Calculate the an unweighted summary statistic from a survey}
\usage{
unweighted(x, .svy = current_svy(), ...)
}
\arguments{
\item{x}{A variable or expression}

\item{.svy}{A \code{tbl_svy} object. When called from inside a summarize function
the default automatically sets the survey to the current survey.}

\item{...}{Ignored}
}
\description{
Calculate unweighted summaries from a survey dataset, just as on
a normal data.frame with \code{\link[dplyr]{summarise}}.
}
\details{
Uses tidy evaluation semantics and so if you want to use
wrapper functions based on variable names, you must use
tidy evaluation, see the examples here, documentation in
\link[rlang]{nse-force}, or the dplyr vignette called
'programming' for more information.
}
\examples{
library(survey)
library(dplyr)
data(api)

dstrata <- apistrat \%>\%
  as_survey_design(strata = stype, weights = pw)

dstrata \%>\%
  summarise(api99_unw = unweighted(mean(api99)),
            n = unweighted(n()))

dstrata \%>\%
  group_by(stype) \%>\%
  summarise(api_diff_unw = unweighted(mean(api00 - api99)))


# If you want to use a wrapper function, be sure to treat
# non-standard evaluation correctly
umean <- function(x) {
  unweighted(mean({{x}}))
}
 dstrata \%>\%
   group_by(stype) \%>\%
   summarize(api_diff_unw = umean(api00 - api99))


}
