\name{verify_input}
\alias{verify_input}
\title{Verify and standardize SS3 input files}
\usage{
verify_input(model_dir, type = c("om", "em"))
}
\arguments{
  \item{model_dir}{Directory name for model. This folder
  should contain the \code{.ctl}, \code{.dat}, files etc.}

  \item{type}{One of "om" or "em" for operating or
  estimating model.}
}
\value{
Returns a version of the folder with sanitized files or an
error if some files are missing.
}
\description{
This function verifies the contents of operating model
(\code{om}) and estimation model (\code{em}) folders. If
the contents are correct, the \code{.ctl} and \code{.dat}
files are renamed to standardized names and the
\code{starter.ss} file is updated to reflect these names.
If the contents are incorrect then a warning is issued and
the simulation is aborted.
}
\details{
This is a helper function to be used within the larger
wrapper simulation functions.
}
\examples{
# Create a temporary folder for the output:
temp_path <- file.path(tempdir(), "ss3sim-verify-example")
dir.create(temp_path, showWarnings = FALSE)

d <- system.file("extdata", package = "ss3sim")

om <- paste0(d, "/models/cod-om")
em <- paste0(d, "/models/cod-em")

file.copy(om, temp_path, recursive = TRUE)
file.copy(em, temp_path, recursive = TRUE)

# Verify the correct files exist and change file names:
verify_input(model_dir = paste0(temp_path, "/cod-om"), type = "om")
verify_input(model_dir = paste0(temp_path, "/cod-em"), type = "em")
}
\author{
Curry James Cunningham; modified by Sean Anderson
}

