% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssMRCD_methods.R
\name{plot.ssMRCD}
\alias{plot.ssMRCD}
\title{Plot Method for ssMRCD Object}
\usage{
\method{plot}{ssMRCD}(
  x,
  type = c("convergence", "ellipses"),
  centersN = NULL,
  colour_scheme = "none",
  xlim_upper = 9,
  manual_rescale = 1,
  legend = TRUE,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{object of class \code{"ssMRCD"}.}

\item{type}{type of plot, possible values are \code{"convergence"} and \code{"ellipses"}. See details.}

\item{centersN}{for plot type \code{"ellipses"} a matrix specifying the positions of
the centers of the covariance estimation centers, see also \code{\link[ssMRCD]{geo_weights}}.}

\item{colour_scheme}{coloring scheme used for plot type \code{"ellipses"}, either \code{"trace"} or \code{"regularity"} or \code{"none"}.}

\item{xlim_upper}{numeric giving the upper x limit for plot type \code{"convergence"}.}

\item{manual_rescale}{for plot type \code{"ellipses"} numeric used to re-scale ellipse sizes.}

\item{legend}{logical, if color legend should be included.}

\item{xlim}{vector of xlim (see \code{\link{par}}).}

\item{ylim}{vector of ylim (see \code{\link{par}}).}

\item{...}{further plotting parameters.}
}
\value{
Returns plots of the ssMRCD methodology and results.
}
\description{
Plots diagnostics for function output of \code{\link[ssMRCD]{ssMRCD}} regarding convergence behavior
and the resulting covariances matrices.
}
\details{
For \code{type = "convergence"} a plot is produced displaying the convergence behaviour.
Each line represents a different initial value used for the c-step iteration. On the x-axis the
iteration step is plotted with the corresponding value of the objective function. Not monotonically
lines are plotted in red. \cr

For \code{type = "ellipses"} and more than a 2-dimensional data setting plotting the exact tolerance ellipse is
not possible anymore. Instead the two eigenvectors with highest eigenvalue from the
MCD used on the full data set without neighborhood assignments are taken and used as axis for
the tolerance ellipses of the ssMRCD covariance estimators. The tolerance ellipse for the global MCD
covariance is plotted in grey in the upper left corner. It is possible to set the colour scheme
to \code{"trace"} to see the overall amount of variabilty and compare the plotted covariance and
the real trace to see how much variance is not plotted. For \code{"regularity"} the regularization of each
covariance is shown.
}
\examples{
# set seed
set.seed(1)

# create data set
data = matrix(rnorm(2000), ncol = 4)
coords = matrix(rnorm(1000), ncol = 2)
N_assignments = sample(1:10, 500, replace = TRUE)
lambda = 0.3

# calculate ssMRCD by using the local outlier detection method
outs = local_outliers_ssMRCD(data = data,
                             coords = coords,
                             N_assignments = N_assignments,
                             lambda = lambda,
                             k = 10)

# plot ssMRCD object included in outs
plot(x = outs$ssMRCD,
     centersN = outs$centersN,
     colour_scheme = "trace",
     legend = FALSE)

}
\seealso{
\code{\link[ssMRCD]{ssMRCD}, \link[ssMRCD]{summary.ssMRCD},
\link[ssMRCD]{local_outliers_ssMRCD}, \link[ssMRCD]{plot.locOuts}}
}
