% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hc.R
\name{ssd_hc}
\alias{ssd_hc}
\alias{ssd_hc.list}
\alias{ssd_hc.fitdists}
\alias{ssd_hc.fitburrlioz}
\title{Hazard Concentrations for Species Sensitivity Distributions}
\usage{
ssd_hc(x, ...)

\method{ssd_hc}{list}(x, percent = 5, hc = 5, ...)

\method{ssd_hc}{fitdists}(
  x,
  percent = 5,
  hc = 5,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  average = TRUE,
  delta = 7,
  min_pboot = 0.99,
  parametric = TRUE,
  control = NULL,
  ...
)

\method{ssd_hc}{fitburrlioz}(
  x,
  percent = 5,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  min_pboot = 0.99,
  parametric = FALSE,
  ...
)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{percent}{A numeric vector of percentages.}

\item{hc}{A whole numeric vector between 1 and 99 indicating the percent hazard concentrations (deprecated for percent).}

\item{ci}{A flag specifying whether to estimate confidence intervals (by parametric bootstrapping).}

\item{level}{A number between 0 and 1 of the confidence level.}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the se and confidence limits. A value of 10000 is recommended for official guidelines.}

\item{average}{A flag specifying whether to model average the estimates.}

\item{delta}{A non-negative number specifying the maximum absolute Akaike Information-theoretic Criterion difference cutoff. Distributions with an absolute difference from the best model greater than the cutoff are excluded.}

\item{min_pboot}{A number of the minimum proportion of bootstrap samples that must successfully fit
in the sense of returning a likelihood.}

\item{parametric}{A flag specifying whether to perform parametric as opposed to non-parametric bootstrapping.}

\item{control}{A list of control parameters passed to \code{\link[stats:optim]{stats::optim()}}.}
}
\value{
A tibble of corresponding hazard concentrations.
}
\description{
Gets concentration(s) that protect specified percentage(s) of species.
}
\details{
If \code{ci = TRUE} uses parameteric bootstrapping to get confidence intervals on the
hazard concentrations(s).
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: Hazard Concentrations for Distributional Estimates

\item \code{fitdists}: Hazard Concentrations for fitdists Object

\item \code{fitburrlioz}: Hazard Concentrations for fitburrlioz Object
'
}}

\examples{
fits <- ssd_fit_dists(ssddata::ccme_boron)
ssd_hc(fits)
ssd_hc(estimates(fits))
ssd_hc(ssd_match_moments())
fit <- ssd_fit_burrlioz(ssddata::ccme_boron)
ssd_hc(fit)

}
\seealso{
\code{\link[=predict.fitdists]{predict.fitdists()}} and \code{\link[=ssd_hp]{ssd_hp()}}.
}
