% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burrrIII3.R, R/gamma.R, R/gompertz.R,
%   R/invpareto.R, R/lgumbel.R, R/llogis-llogis.R, R/llogis.R, R/lnorm-lnorm.R,
%   R/lnorm.R, R/multi.R, R/pqr.R, R/weibull.R
\name{ssd_qburrIII3}
\alias{ssd_qburrIII3}
\alias{ssd_qgamma}
\alias{ssd_qgompertz}
\alias{ssd_qinvpareto}
\alias{ssd_qlgumbel}
\alias{ssd_qllogis_llogis}
\alias{ssd_qllogis}
\alias{ssd_qlnorm_lnorm}
\alias{ssd_qlnorm}
\alias{ssd_qmulti}
\alias{ssd_q}
\alias{ssd_qweibull}
\title{Quantile Function}
\usage{
ssd_qburrIII3(
  p,
  shape1 = 1,
  shape2 = 1,
  scale = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

ssd_qgamma(p, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)

ssd_qgompertz(p, location = 1, shape = 1, lower.tail = TRUE, log.p = FALSE)

ssd_qinvpareto(p, shape = 3, scale = 1, lower.tail = TRUE, log.p = FALSE)

ssd_qlgumbel(
  p,
  locationlog = 0,
  scalelog = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

ssd_qllogis_llogis(
  p,
  locationlog1 = 0,
  scalelog1 = 1,
  locationlog2 = 1,
  scalelog2 = 1,
  pmix = 0.5,
  lower.tail = TRUE,
  log.p = FALSE
)

ssd_qllogis(p, locationlog = 0, scalelog = 1, lower.tail = TRUE, log.p = FALSE)

ssd_qlnorm_lnorm(
  p,
  meanlog1 = 0,
  sdlog1 = 1,
  meanlog2 = 1,
  sdlog2 = 1,
  pmix = 0.5,
  lower.tail = TRUE,
  log.p = FALSE
)

ssd_qlnorm(p, meanlog = 0, sdlog = 1, lower.tail = TRUE, log.p = FALSE)

ssd_qmulti(
  p,
  burrIII3.weight = 0,
  burrIII3.shape1 = 1,
  burrIII3.shape2 = 1,
  burrIII3.scale = 1,
  gamma.weight = 0,
  gamma.shape = 1,
  gamma.scale = 1,
  gompertz.weight = 0,
  gompertz.location = 1,
  gompertz.shape = 1,
  invpareto.weight = 0,
  invpareto.shape = 3,
  invpareto.scale = 1,
  lgumbel.weight = 0,
  lgumbel.locationlog = 0,
  lgumbel.scalelog = 1,
  llogis.weight = 0,
  llogis.locationlog = 0,
  llogis.scalelog = 1,
  llogis_llogis.weight = 0,
  llogis_llogis.locationlog1 = 0,
  llogis_llogis.scalelog1 = 1,
  llogis_llogis.locationlog2 = 1,
  llogis_llogis.scalelog2 = 1,
  llogis_llogis.pmix = 0.5,
  lnorm.weight = 1,
  lnorm.meanlog = 0,
  lnorm.sdlog = 1,
  lnorm_lnorm.weight = 0,
  lnorm_lnorm.meanlog1 = 0,
  lnorm_lnorm.sdlog1 = 1,
  lnorm_lnorm.meanlog2 = 1,
  lnorm_lnorm.sdlog2 = 1,
  lnorm_lnorm.pmix = 0.5,
  weibull.weight = 0,
  weibull.shape = 1,
  weibull.scale = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

ssd_qweibull(p, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{p}{vector of probabilities.}

\item{shape1}{shape1 parameter.}

\item{shape2}{shape2 parameter.}

\item{scale}{scale parameter.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \code{P[X <= x]}, otherwise, \code{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{shape}{shape parameter.}

\item{location}{location parameter.}

\item{locationlog}{location on the log scale parameter.}

\item{scalelog}{scale on log scale parameter.}

\item{locationlog1}{locationlog1 parameter.}

\item{scalelog1}{scalelog1 parameter.}

\item{locationlog2}{locationlog2 parameter.}

\item{scalelog2}{scalelog2 parameter.}

\item{pmix}{Proportion mixture parameter.}

\item{meanlog1}{mean on log scale parameter.}

\item{sdlog1}{standard deviation on log scale parameter.}

\item{meanlog2}{mean on log scale parameter.}

\item{sdlog2}{standard deviation on log scale parameter.}

\item{meanlog}{mean on log scale parameter.}

\item{sdlog}{standard deviation on log scale parameter.}

\item{burrIII3.weight}{weight parameter for the Burr III distribution.}

\item{burrIII3.shape1}{shape1 parameter for the Burr III distribution.}

\item{burrIII3.shape2}{shape2 parameter for the Burr III distribution.}

\item{burrIII3.scale}{scale parameter for the Burr III distribution.}

\item{gamma.weight}{weight parameter for the gamma distribution.}

\item{gamma.shape}{shape parameter for the gamma distribution.}

\item{gamma.scale}{scale parameter for the gamma distribution.}

\item{gompertz.weight}{weight parameter for the Gompertz distribution.}

\item{gompertz.location}{location parameter for the Gompertz distribution.}

\item{gompertz.shape}{shape parameter for the Gompertz distribution.}

\item{invpareto.weight}{weight parameter for the inverse Pareto distribution.}

\item{invpareto.shape}{shape parameter for the inverse Pareto distribution.}

\item{invpareto.scale}{scale parameter for the inverse Pareto distribution.}

\item{lgumbel.weight}{weight parameter for the log-Gumbel distribution.}

\item{lgumbel.locationlog}{location parameter for the log-Gumbel distribution.}

\item{lgumbel.scalelog}{scale parameter for the log-Gumbel distribution.}

\item{llogis.weight}{weight parameter for the log-logistic distribution.}

\item{llogis.locationlog}{location parameter for the log-logistic distribution.}

\item{llogis.scalelog}{scale parameter for the log-logistic distribution.}

\item{llogis_llogis.weight}{weight parameter for the log-logistic log-logistic mixture distribution.}

\item{llogis_llogis.locationlog1}{locationlog1 parameter for the log-logistic log-logistic mixture distribution.}

\item{llogis_llogis.scalelog1}{scalelog1 parameter for the log-logistic log-logistic mixture distribution.}

\item{llogis_llogis.locationlog2}{locationlog2 parameter for the log-logistic log-logistic mixture distribution.}

\item{llogis_llogis.scalelog2}{scalelog2 parameter for the log-logistic log-logistic mixture distribution.}

\item{llogis_llogis.pmix}{pmix parameter for the log-logistic log-logistic mixture distribution.}

\item{lnorm.weight}{weight parameter for the log-normal distribution.}

\item{lnorm.meanlog}{meanlog parameter for the log-normal distribution.}

\item{lnorm.sdlog}{sdlog parameter for the log-normal distribution.}

\item{lnorm_lnorm.weight}{weight parameter for the log-normal log-normal mixture distribution.}

\item{lnorm_lnorm.meanlog1}{meanlog1 parameter for the log-normal log-normal mixture distribution.}

\item{lnorm_lnorm.sdlog1}{sdlog1 parameter for the log-normal log-normal mixture distribution.}

\item{lnorm_lnorm.meanlog2}{meanlog2 parameter for the log-normal log-normal mixture distribution.}

\item{lnorm_lnorm.sdlog2}{sdlog2 parameter for the log-normal log-normal mixture distribution.}

\item{lnorm_lnorm.pmix}{pmix parameter for the log-normal log-normal mixture distribution.}

\item{weibull.weight}{weight parameter for the Weibull distribution.}

\item{weibull.shape}{shape parameter for the Weibull distribution.}

\item{weibull.scale}{scale parameter for the Weibull distribution.}
}
\description{
Quantile Function
}
\section{Functions}{
\itemize{
\item \code{ssd_qburrIII3()}: Quantile Function for BurrIII Distribution

\item \code{ssd_qgamma()}: Quantile Function for Gamma Distribution

\item \code{ssd_qgompertz()}: Quantile Function for Gompertz Distribution

\item \code{ssd_qinvpareto()}: Quantile Function for Inverse Pareto Distribution

\item \code{ssd_qlgumbel()}: Quantile Function for Log-Gumbel Distribution

\item \code{ssd_qllogis_llogis()}: Cumulative Distribution Function for Log-Logistic/Log-Logistic Mixture Distribution

\item \code{ssd_qllogis()}: Cumulative Distribution Function for Log-Logistic Distribution

\item \code{ssd_qlnorm_lnorm()}: Cumulative Distribution Function for Log-Normal/Log-Normal Mixture Distribution

\item \code{ssd_qlnorm()}: Cumulative Distribution Function for Log-Normal Distribution

\item \code{ssd_qmulti()}: Quantile Function for Multiple Distributions

\item \code{ssd_qweibull()}: Cumulative Distribution Function for Weibull Distribution

}}
\examples{

ssd_qburrIII3(0.5)

ssd_qgamma(0.5)

ssd_qgompertz(0.5)

ssd_qinvpareto(0.5)

ssd_qlgumbel(0.5)

ssd_qllogis_llogis(0.5)

ssd_qllogis(0.5)

ssd_qlnorm_lnorm(0.5)

ssd_qlnorm(0.5)

# multi
ssd_qmulti(0.5)

ssd_qweibull(0.5)
}
\seealso{
\code{\link{ssd_p}} and \code{\link{ssd_r}}
}
