% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ssd_ecd_data}
\alias{ssd_ecd_data}
\title{Empirical Cumulative Density for Species Sensitivity Data}
\usage{
ssd_ecd_data(
  data,
  left = "Conc",
  right = left,
  ...,
  bounds = c(left = 1, right = 1)
)
}
\arguments{
\item{data}{A data frame.}

\item{left}{A string of the column in data with the concentrations.}

\item{right}{A string of the column in data with the right concentration values.}

\item{...}{Unused.}

\item{bounds}{A named non-negative numeric vector of the left and right bounds for
uncensored missing (0 and Inf) data in terms of the orders of magnitude
relative to the extremes for non-missing values.}
}
\value{
A numeric vector of the empirical cumulative density for the rows
in data.
}
\description{
Empirical Cumulative Density for Species Sensitivity Data
}
\examples{
ssd_ecd_data(ssddata::ccme_boron)
}
\seealso{
\code{\link[=ssd_ecd]{ssd_ecd()}} and \code{\link[=ssd_data]{ssd_data()}}
}
