% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cp.remote}
\alias{cp.remote}
\title{scp wrapper}
\usage{
cp.remote(remote.src, path.src, remote.dest, path.dest, verbose = FALSE,
  via.local = FALSE, local.temp.dir = tempdir())
}
\arguments{
\item{remote.src}{Remote machine for the source file in the format \code{user@machine} or an empty string for local.}

\item{path.src}{Path of the source file.}

\item{remote.dest}{Remote machine for the destination file in the format \code{user@machine} or an empty string for local.}

\item{path.dest}{Path for the source file; can be a directory.}

\item{verbose}{Prints elapsed time if TRUE}

\item{via.local}{Copies the file via the local machine. Useful when two remote machines can't talk to each other directly.}

\item{local.temp.dir}{When copying via local machine, the directory to use as scratch space.}
}
\description{
A wrapper around the scp shell command that handles local/remote files and allows
copying between remote hosts via the local machine.
}
\examples{
\dontrun{
## Copy file myfile.csv from the home directory on the remote server to
## the local working directory.

## on remote server in bash shell:
# cat myfile.csv
# [me@myserver ~]$ cat myfile.csv
# "val","ts"
# 1,
# 2,
# 3,
# 4,
# 5,
# 6,
# 7,
# 8,
# 9,
# 10,

## on local server in R:
cp.remote(remote.src = "me@myserver", path.src = "~/myfile.csv",
          remote.dest = "", path.dest = getwd(), verbose = TRUE)
# [1] "Elapsed: 1.672 sec"
df <- read.csv("myfile.csv")
df
#    val ts
# 1    1 NA
# 2    2 NA
# 3    3 NA
# 4    4 NA
# 5    5 NA
# 6    6 NA
# 7    7 NA
# 8    8 NA
# 9    9 NA
# 10  10 NA
}
}

