% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ps.grep.remote}
\alias{ps.grep.remote}
\title{Checks for processes running on a local or remote machine.}
\usage{
ps.grep.remote(grep.string, remote, stop.if.any = FALSE,
  stop.if.none = FALSE, count.self = FALSE, ps.options = "aux")
}
\arguments{
\item{grep.string}{String(s) to check for in \code{ps}. If a vector, runs a chain of piped grep commands for each string.}

\item{remote}{Remote machine specification for ssh, in format such as \code{user@server} that does not
require interactive password entry. For local execution, pass an empty string "" (default).}

\item{stop.if.any}{Stop if any of \code{grep.string} is running}

\item{stop.if.none}{Stop if none of \code{grep.string} is running}

\item{count.self}{When \code{FALSE}, excludes the calling process name from the count, if it gets matched.}

\item{ps.options}{Gives the ability to run different options to ps.}
}
\description{
One of the use cases for this function is to ensure that an R process is
already running and not start another one accidentally.
}
\note{
This may not work on Windows.
}
\examples{
\dontrun{
# Check if Eclipse is running.
ps.grep.remote("Eclipse", remote = "")
# [1] TRUE
}
}
\seealso{
\code{run.remote}
}

