% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rho_est.R
\name{rho_est}
\alias{rho_est}
\title{Estimate Rho for Alternative Allele Frequency}
\usage{
rho_est(vl)
}
\arguments{
\item{vl}{A list of vcf objects from read_vcf function.}
}
\value{
A list containing (1) het_rho: Rho parameter of heterozygous location; (2) hom_rho: Rho parameter homozygous location;
}
\description{
Estimates Rho parameter in beta binomial distribution for alternative allele frequency
}
\examples{
data("vcf_example")
vcf_list <- list()
vcf_list[[1]] <- vcf_example$VCF
res <- rho_est(vl = vcf_list)
res$het_rho[[1]]$par
res$hom_rho[[1]]$par
}
