% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stab_asv.R
\name{stab_asv}
\alias{stab_asv}
\alias{stab_asv.default}
\title{Additive Main Effects and Multiplicative Interacion Stability Value}
\usage{
stab_asv(.data, .y, .rep, .gen, .env)

\method{stab_asv}{default}(.data, .y, .rep, .gen, .env)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.rep}{Replication Factor}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}
}
\value{
Additive ANOVA
}
\description{
Additive ANOVA for Genotypes by Environment Interaction (GEI) model
}
\examples{
data(ge_data)
YieldASV <-
     stab_asv(
            .data = ge_data
          , .y    = Yield
          , .rep  = Rep
          , .gen  = Gen
          , .env  = Env
      )
YieldASV

}
\references{
Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Kent M. Edkridge (\email{keskridge1@unl.edu})
         }
}
