% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd2s_and_s2sd.R
\name{Parameter_Conversion}
\alias{Parameter_Conversion}
\alias{s2sd}
\alias{sd2s}
\title{Easy conversion of parameters between stabledist and stable}
\usage{
sd2s(alpha, beta, gamma, delta, pm = 1)

s2sd(tail, skew, disp, loc, pm = 1)
}
\arguments{
\item{alpha}{the stabledist 'alpha'}

\item{beta}{the stabledist 'beta'}

\item{gamma}{the stabledist 'gamma'}

\item{delta}{the stabledist 'delta'}

\item{pm}{default 1; currently only value supported. the stabledist parameterization 'pm'}

\item{tail}{the stable 'tail' analogous to 'alpha'}

\item{skew}{the stable 'skew' analogous to 'beta'}

\item{disp}{the stable 'disp' analogous to 'gamma'}

\item{loc}{the stable 'loc' analogous to 'delta'}
}
\value{
What you need.  See examples.
}
\description{
\code{sd2s} has stabledist parameter inputs and returns stable parameters.
\code{s2sd} has stable     parameter inputs and returns stabledist parameters.
}
\details{
This is a generic function: methods can be defined for it directly
or via the \code{\link{Summary}} group generic. For this to work properly,
the arguments \code{...} should be unnamed, and dispatch is on the
first argument.
}
\examples{
q <- -1
# nolan pm=1 parameters:
a <-  1.3
b <-  -0.4
c <-  2
d <-  0.75
s <- sd2s(alpha=a, beta=b, gamma=c, delta=d)
stable::pstable(q, tail = s$tail, skew=s$skew, disp = s$disp, loc  = s$loc)
stabledist::pstable(q, alpha=a, beta=b , gamma=c , delta=d, pm=1)
sd <- s2sd(tail = s$tail, skew=s$skew, disp = s$disp, loc  = s$loc)
stabledist::pstable(q, alpha=sd$alpha, beta=sd$beta , gamma=sd$gamma , delta=sd$delta, pm=1)
}

