% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bag.R
\name{bag}
\alias{bag}
\title{Multi-indicators / "Bag o Words"}
\usage{
bag(..., prefix = ".", levels = NULL)
}
\arguments{
\item{...}{the columns to bag}

\item{prefix}{a prefix for the column names}

\item{levels}{levels shared among all columns}
}
\value{
a n*p indicator matrix
}
\description{
This creates an indicator matrix from several columns.
}
\examples{

df2 <- structure(list(Dx1 = c("231", "231", "001", "245", "231", "001", 
"231", "001", "231", "001", "001", "245", "001", "231", "245", 
"245", "001", "231", "245", "001"), Dx2 = c("001", "001", "001", 
"001", "001", "001", "001", "234", "001", "234", "001", "001", 
"001", "001", "001", "777", "777", "234", "001", "234"), Dx3 = c("456", 
"001", "444", "444", "001", "001", "444", "001", "001", "001", 
"444", "001", "444", "456", "456", "444", "444", "456", "001", 
"456")), class = "data.frame", row.names = c(NA, -20L))

Y <- 1:nrow(df2)
m <- lm(Y~bag(Dx1, Dx2, Dx3), df2)
summary(m)




}
\references{
\url{https://stackoverflow.com/questions/47055856/search-multiple-columns-for-string-to-set-indicator-variable/57381877#57381877}
}
\author{
\href{https://stackoverflow.com/users/986793/neal-fultz}{Neal Fultz}
}
