% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horner.R
\name{horner.poly}
\alias{horner.poly}
\alias{horner.rational}
\title{Evaluate Polynomial and Rational Functions using Horner's method}
\usage{
horner.poly(x, P)

horner.rational(x, P, Q)
}
\arguments{
\item{x}{a vector}

\item{P}{the coefficients of the polynomial in the numerator, in increasing order}

\item{Q}{the coefficients of the polynomial in the denominator}
}
\value{
a vector
}
\description{
Calculate
}
\details{
\deqn{y = (P_1 + P_2*x + P_3*x^2 + ... ) / ( Q_1 + Q_2*x + Q_3*x^2 + ...)}

If the coefficients have zeros as highest powers, those are ignored.
}
\examples{

P <- c(1,-2,1)
horner.poly(polyroot(P), P)

}
\references{
\url{https://stackoverflow.com/questions/53256945/evaluate-polynominal-function}
}
\author{
\href{https://stackoverflow.com/users/9957245/torvin}{torvin}
}
