% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/butcher.R
\name{axe_model_stack}
\alias{axe_model_stack}
\alias{axe_call.model_stack}
\alias{axe_ctrl.model_stack}
\alias{axe_data.model_stack}
\alias{axe_env.model_stack}
\alias{axe_fitted.model_stack}
\title{Axing a model_stack.}
\usage{
\method{axe_call}{model_stack}(x, verbose = FALSE, ...)

\method{axe_ctrl}{model_stack}(x, verbose = FALSE, ...)

\method{axe_data}{model_stack}(x, verbose = FALSE, ...)

\method{axe_env}{model_stack}(x, verbose = FALSE, ...)

\method{axe_fitted}{model_stack}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are disabled.
Default is \code{FALSE}.}

\item{...}{Additional arguments. Currently ignored.}
}
\value{
Axed model_stack object.
}
\description{
Axing a model_stack.

Remove the call.

Remove controls used for training.

Remove the training data.

Remove environments.

Remove fitted values.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# build a regression model stack
st <-
  stacks() \%>\%
  add_candidates(reg_res_lr) \%>\%
  add_candidates(reg_res_sp) \%>\%
  blend_predictions() \%>\%
  fit_members()
  
# remove any of the "butcherable"
# elements individually
axe_call(st)
axe_ctrl(st)
axe_data(st)
axe_fitted(st)
axe_env(st)

# or do it all at once!
butchered_st <- butcher(st, verbose = TRUE)

format(object.size(st))
format(object.size(butchered_st))
\dontshow{\}) # examplesIf}
}
