% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_annual.R
\docType{class}
\name{report_annual-class}
\alias{report_annual-class}
\alias{report_annual}
\title{Class "report_annual"}
\description{
This class displays annual migration counts, for several counting device, taxa or stages.
}
\section{Slots}{

\describe{
\item{\code{dc}}{Object of class \code{\link{ref_dc-class}}, the counting device, multiple values allowed}

\item{\code{data}}{Object of class \code{"data.frame"} data for report lot}

\item{\code{taxa}}{An object of class \code{\link{ref_taxa-class}}, multiple values allowed}

\item{\code{stage}}{An object of class \code{\link{ref_stage-class}}, multiple values allowed}

\item{\code{anneedebut}}{Object of class \code{\link{ref_year-class}}. ref_year allows to choose year of beginning}

\item{\code{anneefin}}{Object of class \code{\link{ref_year-class}}
ref_year allows to choose last year of the report}
}}

\examples{
require(stacomiR)
# launching stacomi without selecting the scheme or interface
stacomi(gr_interface=FALSE,
	login_window=FALSE,
	database_expected=FALSE)
# the following script will load the Arzal dataset if connected to iav schema

\donttest{
  baseODBC<-get("baseODBC",envir=envir_stacomi)
  baseODBC[c(2,3)]<-rep("iav",2)
  assign("baseODBC",baseODBC,envir_stacomi)
  sch<-rlang::env_get(envir_stacomi, "sch")
  assign("sch","iav.",envir_stacomi)
  r_ann<-new("report_annual")
  r_ann<-choice_c(r_ann,
	  dc=c(5,6,12),
	  taxa=c("Anguilla anguilla"),
	  stage=c("AGJ","AGG"),
	  anneedebut="1996",
	  anneefin="2015",
	  silent=FALSE)
  r_ann<-connect(r_ann)	
}
# the following dataset has been generated by the previous code
data(r_ann)
xtr_ann<-stacomiR::xtable(r_ann,
	dc_name=c("Passe bassins","Piege anguille RG","Piege anguille RD"),
	tax_name="Anguille",
	std_name=c("Arg.","Jaun."))
# below not run but one can create a file as following
\dontrun{
  path=file.path(path.expand(get("datawd",envir=envir_stacomi)),
	  paste(paste(r_ann@dc@dc_selectionne,collapse="+"),"_",
		  paste(r_ann@taxa@data$tax_code,collapse="+"),"_",
		  paste(r_ann@stage@data$std_code,collapse="+"),"_",
		  r_ann@anneedebut@annee_selectionnee,":",
		  r_ann@anneefin@annee_selectionnee,".html",sep=""),fsep ="/")
# here you can add an argument file=path
  print(xtr_ann,type="html")
  
# the following uses the "addtorow" argument which creates nice column headings,
# format.args creates a thousand separator
# again this will need to be saved in a file using the file argument
  print(xtr_ann,
	  add.to.row=get("addtorow",envir_stacomi),
	  include.rownames = TRUE,
	  include.colnames = FALSE,
	  format.args = list(big.mark = " ", decimal.mark = ",")
  )
# barplot transforms the data, further arguments can be passed as to barplot
  barplot(r_ann)
  barplot(r_ann,
	  args.legend=list(x="topleft",bty = "n"),
	  col=c("#CA003E","#1A9266","#E10168","#005327","#FF9194"))
  
# An example with custom arguments for legend.text (overriding plot defauts)
  data(r_ann_adour)
  if (requireNamespace("RColorBrewer", quietly = TRUE)){
	lesdc<-r_ann_adour@dc@data$dc_code[r_ann_adour@dc@data$dc\%in\%r_ann_adour@dc@dc_selectionne]
    barplot(r_ann_adour,
		legend.text=lesdc,
		args.legend=list(x="topleft",bty = "n"),
		col=RColorBrewer::brewer.pal(9,"Spectral"),
		beside=TRUE)
  }
  plot(r_ann_adour)
}
}
\seealso{
Other report Objects: \code{\link{report_dc-class}},
  \code{\link{report_df-class}},
  \code{\link{report_env-class}},
  \code{\link{report_ge_weight-class}},
  \code{\link{report_mig-class}},
  \code{\link{report_mig_char-class}},
  \code{\link{report_mig_env-class}},
  \code{\link{report_mig_interannual-class}},
  \code{\link{report_mig_mult-class}},
  \code{\link{report_sample_char-class}},
  \code{\link{report_sea_age-class}},
  \code{\link{report_silver_eel-class}},
  \code{\link{report_species-class}}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
\concept{report Objects}
\keyword{classes}
