% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_sea_age.R
\docType{class}
\name{report_sea_age-class}
\alias{report_sea_age-class}
\alias{report_sea_age}
\title{Class "report_sea_age"}
\description{
the report_sea_age class is used to dispatch adult salmons to age class according to
their size and to basin dependent limits set by the user. Once checked with graphs and summary
statistics, the results are to be written to the database.
}
\section{Slots}{

\describe{
\item{\code{data}}{A data frame with data generated from the database}

\item{\code{calcdata}}{A list of dc with processed data. This lists consists of two elements
\itemize{
\item (1) data A dataset with age set to be used by the plot and summary methods
\item (2) tj_caracteristitiquelot_car A dataset to import into the database
}}

\item{\code{dc}}{Object of class \link{ref_dc-class}: the control devices}

\item{\code{taxa}}{Object of class \link{ref_taxa-class}: the species}

\item{\code{stage}}{Object of class \link{ref_stage-class} : the stages of the fish}

\item{\code{par}}{Object of class \link{ref_par-class}: the parameters used}

\item{\code{horodatedebut}}{An object of class \code{ref_horodate-class}}

\item{\code{horodatefin}}{An object of class \code{ref_horodate-class}}

\item{\code{limit1hm}}{The size limit, in mm between 1 sea winter fishes and 2 sea winter fishes}

\item{\code{limit2hm}}{The size limit, in mm between 2 sea winter fishes and 3 sea winter fishes}
}}

\note{
This class is displayed by interface_report_sea_age
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("report_sea_age", ...)}
}

\examples{
require(stacomiR)
stacomi(gr_interface=FALSE,
	login_window=FALSE,
	database_expected=FALSE)
\dontrun{
  #create an instance of the class
  r_seaa<-new("report_sea_age")
  baseODBC<-get("baseODBC",envir=envir_stacomi)
  baseODBC[c(2,3)]<-rep("logrami",2)
  assign("baseODBC",baseODBC,envir_stacomi)
  sch<-rlang::env_get(envir_stacomi, "sch")
  assign("sch","logrami.",envir_stacomi)
  r_seaa<-choice_c(r_seaa,
	  dc=c(107,108,101),			
	  horodatedebut="2012-01-01",
	  horodatefin="2012-12-31",
	  limit1hm=675,
	  limit2hm=875,
	  silent=FALSE
  )
  r_seaa<-connect(r_seaa)
  r_seaa<-calcule(r_seaa)
  
}	
# load the dataset generated by previous lines
# Salmons from the loire on two dams
data("r_seaa")
# the calculation will fill the slot calcdata

# stages are in r_seaa@calcdata[["6"]][,"stage"] 
#look at data structure using str(r_seaa@calcdata[["6"]])

# plot data to confirm the split by limits is correct
plot(r_seaa, plot.type=1)

# if there are several dc, data it split by dc
plot(r_seaa, plot.type=2)
\dontrun{
# print a summary statistic, and save the output in a list for later use
  stats<-summary(r_seaa)
  
  
  write_database(r_seaa)
}
}
\seealso{
Other report Objects: \code{\link{report_annual-class}},
  \code{\link{report_dc-class}},
  \code{\link{report_df-class}},
  \code{\link{report_env-class}},
  \code{\link{report_ge_weight-class}},
  \code{\link{report_mig-class}},
  \code{\link{report_mig_char-class}},
  \code{\link{report_mig_env-class}},
  \code{\link{report_mig_interannual-class}},
  \code{\link{report_mig_mult-class}},
  \code{\link{report_sample_char-class}},
  \code{\link{report_silver_eel-class}},
  \code{\link{report_species-class}}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
\concept{report Objects}
\keyword{classes}
