% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_choice.R
\name{charge,ref_choice-method}
\alias{charge,ref_choice-method}
\title{Loading method for Refchoice referential objects}
\usage{
\S4method{charge}{ref_choice}(object, vecteur, label, selected)
}
\arguments{
\item{object}{An object of class ref_choice}

\item{vecteur}{A vector of name, see example code.}

\item{label}{Labels for the choices}

\item{selected}{An integer indicating which object is selected at launch}
}
\value{
An S4 object of class \link{ref_choice-class}
}
\description{
Loading method for Refchoice referential objects
}
\examples{
\dontrun{
object=new('ref_choice')
charge(object,vecteur=c('oui','non'),label='essai',selected=as.integer(1))
}
}
\seealso{
Other referential objects: 
\code{\link{ref_choice-class}},
\code{\link{ref_coe-class}},
\code{\link{ref_dc-class}},
\code{\link{ref_df-class}},
\code{\link{ref_horodate-class}},
\code{\link{ref_list-class}},
\code{\link{ref_par-class}},
\code{\link{ref_parqual-class}},
\code{\link{ref_parquan-class}},
\code{\link{ref_period-class}},
\code{\link{ref_stage-class}},
\code{\link{ref_taxa-class}},
\code{\link{ref_year-class}}
}
\author{
Cedric Briand \email{cedric.briand@eptb-vilaine.fr}
}
\concept{referential objects}
