% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars.R, R/sf.R, R/raster.R, R/ncdf.R,
%   R/proxy.R, R/xts.R, R/OpenStreetMap.R
\name{st_as_stars}
\alias{st_as_stars}
\alias{st_as_stars.list}
\alias{st_as_stars.default}
\alias{st_as_stars.stars}
\alias{st_as_stars.bbox}
\alias{st_as_stars.sf}
\alias{st_as_stars.Raster}
\alias{st_as_stars.ncdfgeom}
\alias{st_as_stars.stars_proxy}
\alias{st_as_stars.xts}
\alias{st_as_stars.OpenStreetMap}
\title{convert objects into a stars object}
\usage{
st_as_stars(.x, ...)

\method{st_as_stars}{list}(.x, ..., dimensions = NULL)

\method{st_as_stars}{default}(.x = NULL, ..., raster = NULL)

\method{st_as_stars}{stars}(.x, ..., curvilinear = NULL, crs = st_crs(4326))

\method{st_as_stars}{bbox}(
  .x,
  ...,
  nx,
  ny,
  dx = dy,
  dy = dx,
  xlim = .x[c("xmin", "xmax")],
  ylim = .x[c("ymin", "ymax")],
  values = 0,
  n = 64800,
  pretty = FALSE,
  inside = FALSE,
  nz
)

\method{st_as_stars}{sf}(.x, ..., name = attr(.x, "sf_column"))

\method{st_as_stars}{Raster}(.x, ..., att = 1)

\method{st_as_stars}{ncdfgeom}(.x, ..., sf_geometry = NA)

\method{st_as_stars}{stars_proxy}(
  .x,
  ...,
  downsample = 0,
  url = attr(.x, "url"),
  envir = parent.frame()
)

\method{st_as_stars}{xts}(.x, ..., dimensions)

\method{st_as_stars}{OpenStreetMap}(.x, ..., as_col = FALSE)
}
\arguments{
\item{.x}{object to convert}

\item{...}{in case \code{.x} is of class \code{bbox}, arguments passed on to \link{pretty}}

\item{dimensions}{object of class dimensions}

\item{raster}{character; the names of the dimensions that denote raster dimensions}

\item{curvilinear}{only for creating curvilinear grids: named length 2 list holding longitude and latitude matrices; the names of this list should correspond to raster dimensions to be replaced}

\item{crs}{object of class \code{crs} with the coordinate reference system of the values in \code{curvilinear}; see details}

\item{nx}{integer; number of cells in x direction; see details}

\item{ny}{integer; number of cells in y direction; see details}

\item{dx}{numeric; cell size in x direction; see details}

\item{dy}{numeric; cell size in y direction; see details}

\item{xlim}{length 2 numeric vector with extent (min, max) in x direction}

\item{ylim}{length 2 numeric vector with extent (min, max) in y direction}

\item{values}{value(s) to populate the raster values with}

\item{n}{the (approximate) target number of grid cells}

\item{pretty}{logical; should cell coordinates have \link{pretty} values?}

\item{inside}{logical; should all cells entirely fall inside the bbox, potentially not covering it completely?}

\item{nz}{integer; number of cells in z direction; if missing no z-dimension is created.}

\item{name}{character; name for the geometry dimensions}

\item{att}{see \link[raster:factor]{factorValues}; column in the RasterLayer's attribute table}

\item{sf_geometry}{sf data.frame with geometry and attributes to be added to stars object. 
Must have same number of rows as timeseries instances.}

\item{downsample}{integer: if larger than 0, downsample with this rate (number of pixels to skip in every row/column); if length 2, specifies downsampling rate in x and y.}

\item{url}{character; URL of the stars endpoint where the data reside}

\item{envir}{environment to resolve objects in}

\item{as_col}{logical; return rgb numbers (FALSE) or (character) color values (TRUE)?}
}
\description{
convert objects into a stars object
}
\details{
if \code{curvilinear} is a \code{stars} object with longitude and latitude values, its coordinate reference system is typically not that of the latitude and longitude values.

For the \code{bbox} method: if \code{pretty} is \code{TRUE}, raster cells may extend the coordinate range of \code{.x} on all sides. If in addition to \code{nx} and \code{ny}, \code{dx} and \code{dy} are also missing, these are set to a single value computed as \code{sqrt(diff(xlim)*diff(ylim)/n)}. If \code{nx} and \code{ny} are missing, they are computed as the ceiling of the ratio of the (x or y) range divided by (dx or dy), unless \code{inside} is \code{TRUE}, in which case ceiling is replaced by floor. Postive \code{dy} will be made negative. Further named arguments (\code{...}) are passed on to \code{pretty}.

For the \code{ncdfgeom} method: objects are point-timeseries with optional line or polygon geometry for each timeseries specified with the \code{sf_geometry} parameter. See \pkg{ncdfgeom} for more about this NetCDF-based format for geometry and timeseries.

for the \code{xts} methods, if \code{dimensions} are provided, time has to be the first dimension.
}
