% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warp.R
\name{st_warp}
\alias{st_warp}
\title{Warp (resample) grids in stars objects to a new grid, possibly in an new coordinate reference system}
\usage{
st_warp(
  src,
  dest,
  ...,
  crs = NA_crs_,
  cellsize = NA_real_,
  segments = 100,
  use_gdal = FALSE,
  options = character(0),
  no_data_value = NA_real_,
  debug = FALSE,
  method = "near"
)
}
\arguments{
\item{src}{object of class \code{stars} with source raster}

\item{dest}{object of class \code{stars} with target raster geometry}

\item{...}{ignored}

\item{crs}{coordinate reference system for destination grid, only used when \code{dest} is missing}

\item{cellsize}{length 1 or 2 numeric; cellsize in target coordinate reference system units}

\item{segments}{(total) number of segments for segmentizing the bounding box before transforming to the new crs}

\item{use_gdal}{logical; if \code{TRUE}, use gdalwarp, through \link[sf]{gdal_utils}}

\item{options}{character vector with options, passed on to gdalwarp}

\item{no_data_value}{value used by gdalwarp for no_data (NA) when writing to temporaray file}

\item{debug}{logical; if \code{TRUE}, do not remove the temporary gdalwarp destination file, and print its name}

\item{method}{character; see details for options; methods other than \code{near} only work when \code{use_gdal=TRUE}}
}
\description{
Warp (resample) grids in stars objects to a new grid, possibly in an new coordinate reference system
}
\details{
\code{method} should be one of \code{near}, \code{bilinear}, \code{cubic}, \code{cubicspline}, \code{lanczos}, \code{average}, \code{mode}, \code{max}, \code{min}, \code{med}, \code{q1} or \code{q3}; see https://github.com/r-spatial/stars/issues/109

For gridded spatial data (dimensions \code{x} and \code{y}), see figure; the existing grid is transformed into a regular grid defined by \code{dest}, possibly in a new coordinate reference system. If \code{dest} is not specified, but \code{crs} is, the procedure used to choose a target grid is similar to that of \link[raster]{projectRaster} (currently only with \code{method='ngb'}). This entails: (i) the envelope (bounding box polygon) is transformed into the new crs, possibly after segmentation (red box); (ii) a grid is formed in this new crs, touching the transformed envelope on its East and North side, with (if cellsize is not given) a cellsize similar to the cell size of \code{src}, with an extent that at least covers \code{x}; (iii) for each cell center of this new grid, the matching grid cell of \code{x} is used; if there is no match, an \code{NA} value is used.
}
\examples{
geomatrix = system.file("tif/geomatrix.tif", package = "stars")
(x = read_stars(geomatrix))
new_crs = st_crs(4326)
y = st_warp(x, crs = new_crs)
plot(st_transform(st_as_sfc(st_bbox(x)), new_crs), col = NA, border = 'red')
plot(st_as_sfc(y, as_points=FALSE), col = NA, border = 'green', axes = TRUE, add = TRUE)
image(y, add = TRUE, nbreaks = 6)
plot(st_as_sfc(y, as_points=TRUE), pch=3, cex=.5, col = 'blue', add = TRUE)
plot(st_transform(st_as_sfc(x, as_points=FALSE), new_crs), add = TRUE)
# warp 0-360 raster to -180-180 raster:
r = read_stars(system.file("nc/reduced.nc", package = "stars"))
r \%>\% st_set_crs(4326) \%>\% st_warp(st_as_stars(st_bbox(), dx = 2)) -> s
plot(r, axes = TRUE) # no CRS set, so no degree symbols in labels
plot(s, axes = TRUE)
}
