% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_schema_snake_case.R
\name{snake_case}
\alias{snake_case}
\alias{snake_case.star_schema}
\title{Transform names according to the snake case style}
\usage{
snake_case(st)

\method{snake_case}{star_schema}(st)
}
\arguments{
\item{st}{A \code{star_schema} object.}
}
\value{
A \code{star_schema} object.
}
\description{
Transform fact, dimension, measurement, and attribute names according to the
snake case style.
}
\details{
This style is suitable if we are going to work with databases.
}
\examples{
library(tidyr)

st <- star_schema(mrs_age, dm_mrs_age) \%>\%
  snake_case()

st <- star_schema(mrs_age, dm_mrs_age) \%>\%
  role_playing_dimension(
    dim_names = c("when", "when_available"),
    name = "When Common",
    attributes = c("Date", "Week", "Year")
  ) \%>\%
  snake_case()

}
\seealso{


Other star schema and constellation definition functions: 
\code{\link{character_dimensions}()},
\code{\link{constellation}()},
\code{\link{role_playing_dimension}()},
\code{\link{star_schema}()}
}
\concept{star schema and constellation definition functions}
