% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_2pop_bern.R
\name{ci_2pop_bern}
\alias{ci_2pop_bern}
\title{Confidence interval for the difference in two population proportions}
\usage{
ci_2pop_bern(
  x,
  y,
  n_x = NULL,
  n_y = NULL,
  conf_level = 0.95,
  type = "two.sided",
  na.rm = F
)
}
\arguments{
\item{x}{a (non-empty) numeric vector of 0 and 1 or a non-negative number representing number of successes.}

\item{y}{a (non-empty) numeric vector of 0 and 1 or a non-negative number representing number of successes.}

\item{n_x}{non-negative number of cases.}

\item{n_y}{non-negative number of cases.}

\item{conf_level}{confidence level of the returned confidence interval. Must be a single number between 0 and 1.}

\item{type}{a character string specifying the type of confidence interval. Must be one of "two.sided" (default), "right" or "left".}

\item{na.rm}{a logical value indicating whether \code{NA} values should be removed before the computation proceeds.}
}
\value{
A 1 x 3 tibble with 'lower_ci', 'upper_ci', and 'conf_level' columns. Values correspond to the lower and upper bounds of the confidence interval, and to the confidence level, respectively.
}
\description{
Computes the interval for different in two proportions from two distinct and independent population.
}
\details{
\code{type} specifies the type of confidence interval. If \code{type} is "two.sided",  the returned confidence interval is \code{(lower_ci, upper_ci)}. If \code{type} is "left", the returned confidence interval is \code{(lower_ci, Inf)}. And, finally, is \code{type} is "right", the returned confidence interval is \code{(-Inf, upper_ci))}.

If \code{is.null(n_x) == T} and \code{is.null(n_y) == T}, then \code{x} and \code{y} must be a numeric value of 0 and 1 and the proportions are computed using \code{x} and \code{y}. If \code{is.null(n_x) == F} and \code{is.null(n_y) == F}, then  \code{x}, \code{y}, \code{n_x} and \code{n_y} must be non-negative integer scalar and \code{x <= n_x} and \code{y <= n_y}.
}
\examples{
x <- 3
n_x <- 100
y <- 50
n_y <- 333
ci_2pop_bern(x, y, n_x, n_y)

x <- rbinom(100, 1, 0.75)
y <- rbinom(500, 1, 0.75)
ci_2pop_bern(x, y)

}
