% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_1pop_norm.R
\name{ci_1pop_norm}
\alias{ci_1pop_norm}
\title{Confidence interval for the normal distribution parameters}
\usage{
ci_1pop_norm(
  x,
  sd_pop = NULL,
  parameter = "mean",
  conf_level = 0.95,
  type = "two.sided",
  na.rm = F
)
}
\arguments{
\item{x}{a (non-empty) numeric vector.}

\item{sd_pop}{a number specifying the known standard deviation of the population.}

\item{parameter}{a character string specifying the parameter in the normal distribution. Must be one of "mean" or "variance".}

\item{conf_level}{confidence level of the returned confidence interval. Must be a single number between 0 and 1.}

\item{type}{a character string specifying the type of confidence interval. Must be one of "two.sided" (default), "right" or "left".}

\item{na.rm}{a logical value indicating whether \code{NA} values should be removed before the computation proceeds.}
}
\value{
A 1 x 3 tibble with 'lower_ci', 'upper_ci', and 'conf_level' columns. Values correspond to the lower and upper bounds of the confidence interval, and the confidence level, respectivel.
}
\description{
Confidence interval for the normal distribution parameters
}
\details{
\code{type} specifies the type of confidence interval. If \code{type} is "two.sided",  the returned confidence interval is \code{(lower_ci, upper_ci)} when \code{parameter} is "mean" or "variance". If \code{type} is "left", the returned confidence interval is \code{(lower_ci, Inf)} when \code{parameter} is "mean" or "variance". And, finally, is \code{type} is "right", the returned confidence interval is \code{(-Inf, upper_ci))} when \code{parameter} is "mean", and the returned confidence interval is \code{(0, upper_ci)} when \code{parameter} is "variance".
}
\examples{
x <- rnorm(1000)
ci_1pop_norm(x) # confidence interval for the mean, unknown variance

x <- rnorm(1000, sd = 2)
ci_1pop_norm(x, sd_pop = 2) # confidence interval for mean, known variance

x <- rnorm(1000, sd = 5)
ci_1pop_norm(x, parameter = "variance") # confidence interval for the variance

}
