% Generated by roxygen2 (4.0.2): do not edit by hand
\name{elapsed}
\alias{as.monthly}
\alias{as.quarterly}
\alias{as.weekly}
\alias{elapsed}
\alias{is.monthly}
\alias{is.quarterly}
\alias{is.weekly}
\alias{monthly,}
\alias{quarterly,}
\alias{weekly}
\title{Elapsed dates (weekly, monthly, quarterly)}
\usage{
as.quarterly(x)

as.monthly(x)

as.weekly(x)

is.quarterly(x)

is.monthly(x)

is.weekly(x)
}
\arguments{
\item{x}{a vector}
}
\description{
Elapsed dates (weekly, monthly, quarterly)
}
\details{
Weekly, monthly and quarterly dates are stored as integers, representing the number of elapsed calendar periods since 01/01/1970. This allows to use arithmetic on dates other than daily, ie \code{date} + 1 adds one period rather than one day. Moreover, these dates are printed in a way that fits their frequency  (\code{YYY}q\code{q}, \code{YYY}m\code{MM}, \code{YYY}w\code{WW}).

Methods to convert from and to Dates or POSIXlt are provided. In particular, you may use lubridate \code{\link{week}} \code{\link{month}} and \code{\link{year}} to extract information from elapsed dates.
}
\examples{
library(lubridate)
date <- mdy(c("04/03/1992", "01/04/1992", "03/15/1992"))
datem <- as.monthly(date)
is.monthly(datem)
as.weekly(date)
as.quarterly(date)
as.character(datem)
datem + 1
lag(c(1, 2, 3), n = 1, along_with = datem)
seq(datem[1], datem[2])
as.Date(datem)
as.POSIXlt(datem)
as.POSIXct(datem)
week(datem)
}

