% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/set.R
\name{keep_if}
\alias{keep_if}
\alias{keep_if_}
\title{Create new data.table by keeping only certain rows(equivalent to dplyr::filter)}
\usage{
keep_if(x, ..., by = NULL)

keep_if_(x, .dots, by = NULL)
}
\arguments{
\item{x}{a data.table}

\item{...}{Conditions}

\item{by}{groups in which the condition should be evaluated}

\item{.dots}{Used to work around non-standard evaluation.}
}
\description{
Create new data.table by keeping only certain rows(equivalent to dplyr::filter)
}
\examples{
library(data.table)
DT <- data.table(
  id = c(1,2,1),
  v1 = c(1,NA,2)
)
keep_if(DT, v1 == 1)
keep_if(DT, v1 == min(v1), by = id)
}

