% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_binmean.R
\name{stat_binmean}
\alias{stat_binmean}
\title{Plot the mean of y over the mean of x within bins of x.}
\usage{
stat_binmean(mapping = NULL, data = NULL, geom = "point",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  na.rm = FALSE, n = 20, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{n}{number of x-bins. Default to 20. Set to zero if you want to use distinct value of x for grouping.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
a data.frame with additional columns:
  \item{xtile}{bins for x}
  \item{x}{mean of x}
  \item{y}{mean of y}
}
\description{
Plot the mean of y over the mean of x within bins of x.
}
\examples{
library(ggplot2)
g <- ggplot(iris, aes(x = Sepal.Width , y = Sepal.Length)) 
g + stat_binmean(n = 10)
g + stat_binmean(n = 10) + stat_smooth(method = "lm", se = FALSE)
g + stat_binmean(n = 0) 
g <- ggplot(iris, aes(x = Sepal.Width , y = Sepal.Length, color = Species))
g + stat_binmean(n = 10)
g + stat_binmean(n = 10) + stat_smooth(method = "lm", se = FALSE)
}

