% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/distance_measures.R
\name{hellinger_distance}
\alias{hellinger_distance}
\title{Distance measure between ordinal pattern distributions: Hellinger distance}
\usage{
hellinger_distance(p, q)
}
\arguments{
\item{p}{An ordinal pattern distribution}

\item{q}{A second ordinal pattern distribution to compare against p.}
}
\value{
A vector of length 1.
}
\description{
Compute the Hellinger Distance
}
\details{
This function returns a distance measure.
}
\examples{
p = ordinal_pattern_distribution(rnorm(10000), ndemb = 5)
q = ordinal_pattern_distribution(arima.sim(model=list(ar=0.9), n= 10000), ndemb = 5)
hellinger_distance(p=p, q = q)
}
\author{
Sebastian Sippel
}
\references{
none
}

