/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.IntArray;
import blbutil.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import vcf.Marker;
import vcf.SeqCodedRefGT;
import vcf.VcfEmission;

public class VcfEmissionCompressor {
    private final Samples samples;
    private final int capacity;
    private final int[] hapToSeq;
    private final List<Marker> markers;
    private final List<IntList> alleleToSeqList;
    private final List<IntList> sequences;
    private final IntList copiedSeqToSrcSeq;
    private int nSeq;

    public VcfEmissionCompressor(Samples samples, int n) {
        if (samples == null) {
            throw new NullPointerException("samples==null");
        }
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.samples = samples;
        this.capacity = n;
        this.hapToSeq = new int[2 * samples.nSamples()];
        this.markers = new ArrayList<Marker>(100);
        this.sequences = new ArrayList<IntList>(100);
        this.alleleToSeqList = new ArrayList<IntList>(100);
        this.copiedSeqToSrcSeq = new IntList(50);
        this.clear();
    }

    public Samples samples() {
        return this.samples;
    }

    public int capacity() {
        return this.capacity;
    }

    public boolean addToCompessedList(VcfEmission vcfEmission) {
        int n;
        this.checkEmission(vcfEmission);
        if (this.inconsistentChrom(vcfEmission) || vcfEmission.marker().nAlleles() > this.capacity) {
            return false;
        }
        boolean bl = true;
        int n2 = this.nSeq;
        for (n = 0; n < this.nSeq; ++n) {
            this.alleleToSeqList.get(n).clear();
        }
        this.copiedSeqToSrcSeq.clear();
        for (n = 0; n < this.hapToSeq.length && bl; ++n) {
            bl = this.addHaplotype(vcfEmission, n);
        }
        if (bl) {
            this.markers.add(vcfEmission.marker());
        } else {
            this.rollBackChanges(n2);
        }
        return bl;
    }

    private void checkEmission(VcfEmission vcfEmission) {
        if (!vcfEmission.samples().equals(this.samples)) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        if (!vcfEmission.isRefData()) {
            throw new IllegalArgumentException("unphased data");
        }
    }

    private boolean inconsistentChrom(VcfEmission vcfEmission) {
        return !this.markers.isEmpty() && vcfEmission.marker().chromIndex() != this.markers.get(0).chromIndex();
    }

    private boolean addHaplotype(VcfEmission vcfEmission, int n) {
        int n2 = this.hapToSeq[n];
        int n3 = vcfEmission.allele(n);
        IntList intList = this.alleleToSeqList.get(n2);
        if (intList.isEmpty()) {
            intList.add(n3);
            intList.add(n2);
            this.sequences.get(n2).add(n3);
        } else {
            int n4;
            for (n4 = 0; n4 < intList.size() && intList.get(n4) != n3; n4 += 2) {
            }
            if (n4 == intList.size()) {
                if (this.nSeq == this.capacity) {
                    return false;
                }
                this.addCopyOfSequence(n2);
                this.sequences.get(this.nSeq - 1).add(n3);
                intList.add(n3);
                intList.add(this.nSeq - 1);
                this.copiedSeqToSrcSeq.add(n2);
            }
            this.hapToSeq[n] = intList.get(n4 + 1);
        }
        return true;
    }

    private void rollBackChanges(int n) {
        this.alleleToSeqList.subList(n, this.nSeq).clear();
        this.sequences.subList(n, this.nSeq).clear();
        this.nSeq = n;
        for (int i = 0; i < this.hapToSeq.length; ++i) {
            if (this.hapToSeq[i] < n) continue;
            this.hapToSeq[i] = this.copiedSeqToSrcSeq.get(this.hapToSeq[i] - n);
        }
    }

    public int size() {
        return this.markers.size();
    }

    public int nSeq() {
        return this.nSeq;
    }

    public Marker marker(int n) {
        return this.markers.get(n);
    }

    public IntArray hapToSeq() {
        if (this.nSeq == 0) {
            return IntArray.create(this.hapToSeq, 0, 0);
        }
        return IntArray.create(this.hapToSeq, 0, this.nSeq - 1);
    }

    public IntArray seqToAllele(int n) {
        int n2 = this.markers.get(n).nAlleles() - 1;
        int[] nArray = new int[this.nSeq];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.sequences.get(i).get(n);
        }
        return IntArray.create(nArray, 0, n2);
    }

    public List<VcfEmission> getCompressedList() {
        ArrayList<VcfEmission> arrayList = new ArrayList<VcfEmission>(this.markers.size());
        IntArray intArray = this.hapToSeq();
        int n = this.markers.size();
        for (int i = 0; i < n; ++i) {
            Marker marker = this.markers.get(i);
            IntArray intArray2 = this.seqToAllele(i);
            arrayList.add(new SeqCodedRefGT(marker, this.samples, intArray, intArray2));
        }
        return arrayList;
    }

    public final void clear() {
        Arrays.fill(this.hapToSeq, 0);
        this.markers.clear();
        this.sequences.clear();
        this.alleleToSeqList.clear();
        this.copiedSeqToSrcSeq.clear();
        this.nSeq = 0;
        this.addEmptySequence();
    }

    private void addEmptySequence() {
        this.alleleToSeqList.add(new IntList(4));
        this.sequences.add(new IntList(100));
        ++this.nSeq;
    }

    private void addCopyOfSequence(int n) {
        this.addEmptySequence();
        IntList intList = this.sequences.get(n);
        IntList intList2 = this.sequences.get(this.nSeq - 1);
        assert (intList2.isEmpty());
        int n2 = this.markers.size();
        for (int i = 0; i < n2; ++i) {
            intList2.add(intList.get(i));
        }
    }
}

