% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createQTLMPP.R
\name{plot.QTLMPP}
\alias{plot.QTLMPP}
\title{Plot function for the class \code{QTLMPP}}
\usage{
\method{plot}{QTLMPP}(
  x,
  ...,
  plotType = c("QTLProfile", "parEffs", "QTLRegion", "QTLProfileExt"),
  title = NULL,
  output = TRUE
)
}
\arguments{
\item{x}{An object of class \code{QTLMPP}.}

\item{...}{further arguments to be passed on to the actual plotting
functions.}

\item{plotType}{A character string indicating the type of plot to be made.
One of "QTLProfile", "parEffs", and "QTLRegion".}

\item{title}{A character string, the title of the plot.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE}, only a ggplot object is invisibly returned.}
}
\description{
Creates a plot of an object of S3 class \code{QTLMPP}. The following types of
plot can be made:
\itemize{
\item{QTLProfile}{ A QTL profile plot, i.e. a plot of \eqn{-log10(p)} values
per marker.}
\item{parEffs} { A plot of effect sizes and directions per parent.}
\item{QTLRegion}{ A plot highlighting the QTLs found on the genetic map.}
\item{QTLProfileExt}{ A combination of the QTL profile and parental effects
plotted above each other.}
}
See details for a detailed description of the plots and the plot options
specific to the different plots.
}
\section{QTL Profile plot}{

A profile of all marker positions and corresponding \eqn{-log10(p)} values is
plotted. QTLs found are highlighted with red dots. The threshold is plotted
as a horizontal line. If there are previously known marker effects, false
positives and true negatives can also be marked.\cr
Extra parameter options:
\describe{
\item{\code{xLab}}{A character string, the x-axis label. Default =
\code{"Chromosomes"}}
\item{\code{yLab}}{A character string, the y-axis label. Default =
\code{-log10(p)}}
\item{\code{effects}}{A character vector, indicating which markers correspond
to a real (known) effect. Used for determining true/false positives and
false negatives. True positives are colored green, false positives orange and
false negatives yellow.}
\item{\code{colPalette}}{A color palette used for plotting. Default
coloring is done by chromosome, using black and grey.}
\item{\code{signLwd}}{A numerical value giving the thickness of the
points that are false/true positives/negatives. Default = 0.6}
\item{\code{chr}}{A vector of chromosomes to be plotted. By default, all
chromosomes are plotted. Using this option allows restricting the plot to a
subset of chromosomes.}
}
}

\section{Parental effects Plot}{

A plot of effect sizes for each of the parents for the QTLs found is
created.\cr
Extra parameter options:
\describe{
\item{\code{xLab}}{A character string, the x-axis label. Default =
\code{"Chromosomes"}}
\item{\code{yLab}}{A character string, the y-axis label. Default =
\code{"Parents"}}
#' \item{\code{chr}}{A vector of chromosomes to be plotted. By default, all
chromosomes are plotted. Using this option allows restricting the plot to a
subset of chromosomes.}
}
}

\section{QTL Region Plot}{

A plot of effect is created on which the positions of the QTLs found in
the QTL detection are highlighted in red.\cr
No extra parameter options.
}

\section{Extended QTL Profile Plot}{

An extended version of the QTL Profile Plot, in which the QLT profile plot is
combined with the parental effect plot to make it easier to assess the
effects for each specific QTL found.\cr
Extra parameter options:
\describe{
\item{\code{chr}}{A vector of chromosomes to be plotted. By default, all
chromosomes are plotted. Using this option allows restricting the plot to a
subset of chromosomes.}
}
}

\examples{
\dontrun{
## Read phenotypic data.
pheno <- read.delim(system.file("extdata/multipop", "AxBxCpheno.txt",
                               package = "statgenMPP"))
## Rename first column to genotype.
colnames(pheno)[1] <- "genotype"


## Compute IBD probabilities for simulated population - AxB, AxC.
ABC <- calcIBDMPP(crossNames = c("AxB", "AxC"),
                  markerFiles = c(system.file("extdata/multipop", "AxB.txt",
                                              package = "statgenMPP"),
                                  system.file("extdata/multipop", "AxC.txt",
                                              package = "statgenMPP")),
                  pheno = pheno,
                  popType = "F4DH",
                  mapFile = system.file("extdata/multipop", "mapfile.txt",
                                        package = "statgenMPP"),
                  evalDist = 5)

## Multi-QTL Mapping.
ABC_MQM <- selQTLMPP(ABC, trait = "pheno")

## QTL Profile plot.
plot(ABC_MQM, plotType = "QTLProfile")

## Plot of parental effects for QTLs found.
plot(ABC_MQM, plotType = "parEffs")

## Plot of genetic map highlighting positions of QTLs found.
plot(ABC_MQM, plotType = "QTLRegion")

## Extended QTL Profile plot.
plot(ABC_MQM, plotType = "QTLProfileExt")
}

}
