% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\docType{class}
\name{NVL}
\alias{NVL}
\alias{NVL}
\alias{NVL<-}
\title{Convenience functions for handling \code{\link{NULL}} objects.}
\usage{
NVL(...)

NVL(x) <- value
}
\arguments{
\item{\dots}{Expressions to be tested.}

\item{x}{an object to be overwritten if \code{\link{NULL}}.}

\item{value}{new value for \code{x}.}
}
\description{
Convenience functions for handling \code{\link{NULL}} objects.
}
\section{Functions}{
\itemize{
\item \code{NVL}: Inspired by SQL function \code{NVL}, \code{NVL(...)} returns the first
argument that is not \code{NULL}, or \code{NULL} if all arguments
are \code{NULL}.

\item \code{NVL<-}: Assigning to \code{NVL} overwrites its first argument if that argument
is \code{\link{NULL}}. Note that it will \emph{always} return the right-hand-side
of the assignment (\code{value}), regardless of what \code{x} is.
}}

\examples{

a <- NULL

print(a) # NULL
print(NVL(a,0)) # 0

b <- 1

print(b) # 1
print(NVL(b,0)) # 1

# Also,
print(NVL(NULL,1,0)) # 1
print(NVL(NULL,0,1)) # 0
print(NVL(NULL,NULL,0)) # 0
print(NVL(NULL,NULL,NULL)) # NULL

NVL(a) <- 2
a # 2
NVL(b) <- 2
b # still 1
}
\seealso{
\code{\link{NULL}}, \code{\link[base]{is.null}}, \code{\link[base]{if}}
}
\keyword{utilities}
