% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rle_utils.R
\name{rle.utils}
\alias{rle.utils}
\alias{c.rle}
\alias{!.rle}
\alias{binop.rle}
\alias{|.rle}
\alias{&.rle}
\alias{compact.rle}
\alias{any.rle}
\alias{all.rle}
\alias{*.rle}
\alias{/.rle}
\alias{-.rle}
\alias{+.rle}
\alias{^.rle}
\alias{\%\%.rle}
\alias{\%/\%.rle}
\alias{==.rle}
\alias{>.rle}
\alias{<.rle}
\alias{!=.rle}
\alias{<=.rle}
\alias{>=.rle}
\alias{rep.rle}
\title{RLE utilities}
\usage{
\method{c}{rle}(...)

\method{!}{rle}(x)

binop.rle(e1, e2, FUN)

\method{|}{rle}(e1, e2)

\method{&}{rle}(e1, e2)

compact.rle(x)

\method{any}{rle}(..., na.rm = FALSE)

\method{all}{rle}(..., na.rm = FALSE)

\method{*}{rle}(e1, e2)

\method{/}{rle}(e1, e2)

\method{-}{rle}(e1, e2)

\method{+}{rle}(e1, e2)

\method{^}{rle}(e1, e2)

\method{\%\%}{rle}(e1, e2)

\method{\%/\%}{rle}(e1, e2)

\method{==}{rle}(e1, e2)

\method{>}{rle}(e1, e2)

\method{<}{rle}(e1, e2)

\method{!=}{rle}(e1, e2)

\method{<=}{rle}(e1, e2)

\method{>=}{rle}(e1, e2)

\method{rep}{rle}(x, ..., scale = c("element", "run"))
}
\arguments{
\item{...}{For \code{c}, objects to be concatenated. The first object must be of
class \code{\link[=rle]{rle()}}. For \code{rep}, see documentation for \code{\link[=rep]{rep()}}.}

\item{x, e1, e2}{Arguments to unary (\code{x}) and binary (\code{e1} and \code{e2})
operators.}

\item{FUN}{A binary function or operator or a name of one. It is
assumed to be vectorized: it expects two vectors of equal lengths
and outputs a vector of the same length.}

\item{na.rm}{see documentation for \code{\link[=any]{any()}} and \code{\link[=all]{all()}}.}

\item{scale}{whether to replicate the elements of the
RLE-compressed vector or the runs.}
}
\value{
All functions return an \code{\link[=rle]{rle()}} object. By default, the
functions and the operators do not merge adjacent runs with
the same value. This must be done explicitly with \code{\link[=compact.rle]{compact.rle()}}.
}
\description{
Simple utilities for operations on RLE-encoded vectors.
}
\section{Functions}{
\itemize{
\item \code{binop.rle}: Perform an arbitrary binary operation on the pair of vectors
represented by the \code{\link[=rle]{rle()}} objects.

\item \code{compact.rle}: Compact the \code{\link[=rle]{rle()}} object by merging adjacent runs.
}}

\note{
Since \code{\link[=rle]{rle()}} stores run lengths as integers, \code{\link[=compact.rle]{compact.rle()}}
will not merge runs that add up to lengths greater than what can
be represented by a 32-bit signed integer
(\Sexpr{.Machine$integer.max}).

The \code{\link[=rep]{rep()}} method for \code{\link[=rle]{rle()}} objects is very limited at
this time: . Even though the default setting is to replicate
elements of the vector, only the run-replicating functionality is
implemented at this time.
}
\examples{

x <- rle(as.logical(rbinom(10,1,.7)))
y <- rle(as.logical(rbinom(10,1,.3)))

stopifnot(c(inverse.rle(x),inverse.rle(y))==inverse.rle(c(x,y)))

stopifnot((!inverse.rle(x))==inverse.rle(!x))
stopifnot((inverse.rle(x)|inverse.rle(y))==inverse.rle(x|y))
stopifnot((inverse.rle(x)&inverse.rle(y))==inverse.rle(x&y))
stopifnot(identical(rle(inverse.rle(x)&inverse.rle(y)),compact.rle(x&y)))

big <- structure(list(lengths=as.integer(rep(.Machine$integer.max/4,6)),
                      values=rep(TRUE,6)), class="rle")

stopifnot(all(aggregate(as.numeric(lengths)~values,
                        data=as.data.frame(unclass(big)),FUN=sum)
              ==
              aggregate(as.numeric(lengths)~values,
                        data=as.data.frame(unclass(compact.rle(big))),
                        FUN=sum)))

x <- rle(as.logical(rbinom(10,1,.9)))
y <- rle(as.logical(rbinom(10,1,.1)))

stopifnot(any(x)==any(inverse.rle(x)))
stopifnot(any(y)==any(inverse.rle(y)))


stopifnot(all(x)==all(inverse.rle(x)))
stopifnot(all(y)==all(inverse.rle(y)))


x <- rle(sample(c(-1,+1), 10, c(.7,.3), replace=TRUE))
y <- rle(sample(c(-1,+1), 10, c(.3,.7), replace=TRUE))

stopifnot((inverse.rle(x)*inverse.rle(y))==inverse.rle(x*y))
stopifnot((inverse.rle(x)/inverse.rle(y))==inverse.rle(x/y))
stopifnot((-inverse.rle(y))==inverse.rle(-y))
stopifnot((inverse.rle(x)-inverse.rle(y))==inverse.rle(x-y))
stopifnot((+inverse.rle(y))==inverse.rle(+y))
stopifnot((inverse.rle(x)+inverse.rle(y))==inverse.rle(x+y))
stopifnot((inverse.rle(x)^inverse.rle(y))==inverse.rle(x^y))
stopifnot((inverse.rle(x)\%\%inverse.rle(y))==inverse.rle(x\%\%y))
stopifnot((inverse.rle(x)\%/\%inverse.rle(y))==inverse.rle(x\%/\%y))
stopifnot((inverse.rle(x)==inverse.rle(y))==inverse.rle(x==y))
stopifnot((inverse.rle(x)>inverse.rle(y))==inverse.rle(x>y))
stopifnot((inverse.rle(x)<inverse.rle(y))==inverse.rle(x<y))
stopifnot((inverse.rle(x)!=inverse.rle(y))==inverse.rle(x!=y))
stopifnot((inverse.rle(x)<=inverse.rle(y))==inverse.rle(x<=y))
stopifnot((inverse.rle(x)>=inverse.rle(y))==inverse.rle(x>=y))

x <- rle(sample(c(-1,+1), 10, c(.7,.3), replace=TRUE))
y <- rpois(length(x$lengths), 2)


stopifnot(all(rep(inverse.rle(x), rep(y, x$lengths))==inverse.rle(rep(x, y, scale="run"))))
}
