% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{pi.score2}
\alias{pi.score2}
\title{Prediction interval for a difference of scores}
\usage{
pi.score2(alpha, m1, m2, sd1, sd2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{sample mean for group 1}

\item{m2}{sample mean for group 1}

\item{sd1}{sample standard deviation for group 1}

\item{sd2}{sample standard deviation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 2-row matrix. The columns are:
\itemize{
\item Predicted - predicted difference in scores
\item df - degrees of freedom
\item LL - lower limit of the prediction interval
\item UL - upper limit of the prediction interval
}
}
\description{
For a 2-group experimental design, this function computes a prediction
interval for how the response variable score for one randomly selected
person from the study population would differ under the two treatment
conditions. Both equal variance and unequal variance prediction intervals
are computed.
}
\examples{
pi.score2(.05, 29.57, 18.35, 2.68, 1.92, 40, 45)

# Should return:
#                              Predicted       df       LL       UL
# Equal Variances Assumed:         11.22 83.00000 4.650454 17.78955
# Equal Variances Not Assumed:     11.22 72.34319 4.603642 17.83636
 

}
\references{
\insertRef{Hahn1977}{statpsych}
}
