% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.2x2.median.mixed}
\alias{ci.2x2.median.mixed}
\title{Computes confidence intervals in a 2x2 mixed design for medians}
\usage{
ci.2x2.median.mixed(alpha, y11, y12, y21, y22)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y11}{vector of scores at level 1 of A in group 1}

\item{y12}{vector of scores at level 2 of A in group 1}

\item{y21}{vector of scores at level 1 of A in group 2}

\item{y22}{vector of scores at level 2 of A in group 2}
}
\value{
Returns a 7-row matrix (one row per effect). The columns are:
\itemize{
\item Estimate - estimate of effect
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes distribution-free confidence intervals based on medians for the AB
interaction effect, main effect of A, main efect of B, simple main effects
of A, and simple main effects of B in a 2x2 mixed design where Factor A is
the within-subjects factor and Factor B is the between subbjects factor.
Tied scores are assumed to be rare.
}
\examples{
y11 <- c(18, 19, 20, 17, 20, 16)
y12 <- c(19, 18, 19, 20, 17, 16)
y21 <- c(19, 16, 16, 14, 16, 18)
y22 <- c(16, 10, 12,  9, 13, 15)
ci.2x2.median.mixed(.05, y11, y12, y21, y22)

# Should return:
#          Estimate       SE         LL       UL
# AB:         -3.50 2.698647 -8.7892514 1.789251
# A:           1.75 1.349324 -0.8946257 4.394626
# B:           4.25 1.017564  2.2556114 6.244389
# A at b1:     0.00 1.489007 -2.9184005 2.918400
# A at b2:     3.50 2.250679 -0.9112492 7.911249
# B at a1:     2.50 1.486420 -0.4133294 5.413329
# B at a2:     6.00 1.871571  2.3317887 9.668211


}
\references{
\insertRef{Bonett2020}{statpsych}
}
