% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_contingency_tabs_expressions.R
\name{expr_contingency_tab}
\alias{expr_contingency_tab}
\alias{expr_onesample_proptest}
\title{Making expression for contingency table and goodness of fit tests}
\usage{
expr_contingency_tab(
  data,
  x,
  y = NULL,
  counts = NULL,
  ratio = NULL,
  nboot = 100,
  paired = FALSE,
  stat.title = NULL,
  legend.title = NULL,
  conf.level = 0.95,
  conf.type = "norm",
  bias.correct = TRUE,
  k = 2,
  messages = TRUE,
  ...
)

expr_onesample_proptest(
  data,
  x,
  y = NULL,
  counts = NULL,
  ratio = NULL,
  nboot = 100,
  paired = FALSE,
  stat.title = NULL,
  legend.title = NULL,
  conf.level = 0.95,
  conf.type = "norm",
  bias.correct = TRUE,
  k = 2,
  messages = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The variable to use as the \strong{rows} in the contingency table.}

\item{y}{The variable to use as the \strong{columns} in the contingency
table. Default is \code{NULL}. If \code{NULL}, one-sample proportion test (a goodness
of fit test) will be run for the \code{main} variable. Otherwise an appropriate
association test will be run.}

\item{counts}{A string naming a variable in data containing counts, or \code{NULL}
if each row represents a single observation (Default).}

\item{ratio}{A vector of proportions: the expected proportions for the
proportion test (should sum to 1). Default is \code{NULL}, which means the null
is equal theoretical proportions across the levels of the nominal variable.
This means if there are two levels this will be \code{ratio = c(0.5,0.5)} or if
there are four levels this will be \code{ratio = c(0.25,0.25,0.25,0.25)}, etc.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{paired}{Logical indicating whether data came from a within-subjects or
repeated measures design study (Default: \code{FALSE}). If \code{TRUE}, McNemar's
test subtitle will be returned. If \code{FALSE}, Pearson's chi-square test will
be returned.}

\item{stat.title}{Title for the effect being investigated with the chi-square
test. The default is \code{NULL}, i.e. no title will be added to describe the
effect being shown. An example of a \code{stat.title} argument will be something
like \code{"main x condition"} or \code{"interaction"}.}

\item{legend.title}{Title text for the legend.}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{bias.correct}{If \code{TRUE} (default), a bias correction will be applied to
Cramer's \emph{V}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Expression for contingency analysis (Pearson's chi-square test for
independence for between-subjects design or McNemar's test for
within-subjects design) or goodness of fit test for a single categorical
variable.
}
\description{
Making expression for contingency table and goodness of fit tests
}
\details{
For more details about how the effect sizes and their confidence
intervals were computed, see documentation in \code{?rcompanion::cramerV},
\code{?rcompanion::cramerVFit}, and \code{?rcompanion::cohenG}.
}
\examples{

\donttest{
# ------------------------ association tests -----------------------------

set.seed(123)
library(statsExpressions)

# without counts data
statsExpressions::expr_contingency_tab(
  data = mtcars,
  x = am,
  y = cyl,
  paired = FALSE,
  nboot = 15
)

# ------------------------ goodness of fit tests ---------------------------

# for reproducibility
set.seed(123)

# with counts
expr_contingency_tab(
  data = as.data.frame(HairEyeColor),
  x = Eye,
  counts = Freq,
  ratio = c(0.2, 0.2, 0.3, 0.3)
)
}
}
\references{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
