% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_anova.R
\name{expr_anova_robust}
\alias{expr_anova_robust}
\title{Expression containing results from heteroscedastic one-way ANOVA for
trimmed means}
\usage{
expr_anova_robust(
  data,
  x,
  y,
  subject.id = NULL,
  paired = FALSE,
  k = 2L,
  conf.level = 0.95,
  tr = 0.1,
  nboot = 100L,
  output = "expression",
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{subject.id}{In case of repeated measures design (\code{paired = TRUE},
i.e.), this argument specifies the subject or repeated measures id. Note
that if this argument is \code{NULL} (which is the default), the function
assumes that the data has already been sorted by such an id by the user and
creates an internal identifier. So if your data is \strong{not} sorted and you
leave this argument unspecified, the results can be inaccurate.}

\item{paired}{Decides whether the design is repeated measures or not
(Default: \code{FALSE}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} confidence/credible intervals (\code{0.95}).}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. If you
get error stating "Standard error cannot be computed because of Winsorized
variance of 0 (e.g., due to ties). Try to decrease the trimming level.",
try to play around with the value of \code{tr}, which is by default set to
\code{0.1}. Lowering the value might help.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{output}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
\description{
Expression containing results from heteroscedastic one-way ANOVA for
trimmed means
}
\examples{
# for reproducibility
set.seed(123)
library(statsExpressions)

# ------------------------ between-subjects -----------------------------

expr_anova_robust(
  data = ggplot2::midwest,
  x = state,
  y = percbelowpoverty
)

# ------------------------ within-subjects -----------------------------

expr_anova_robust(
  data = iris_long,
  x = condition,
  y = value,
  paired = TRUE,
  k = 3
)
}
